/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore_Test;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameDb;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import java.util.List;

public class MergingNarrowFrameStore_Test
extends FrameStore_Test {
    protected FrameStore createFrameStore(DefaultKnowledgeBase defaultKnowledgeBase) {
        return new InMemoryFrameStore(defaultKnowledgeBase);
    }

    private MergingNarrowFrameStore getMergingFrameStore() {
        InMemoryFrameStore inMemoryFrameStore = (InMemoryFrameStore)this.getModifiableFrameStore(null);
        return (MergingNarrowFrameStore)inMemoryFrameStore.getHelper().getDelegate();
    }

    public void testMergingGetOwnSlotValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        List list = MergingNarrowFrameStore_Test.makeList("foo", "bar");
        simpleInstance.setOwnSlotValues(slot, list);
        MergingNarrowFrameStore_Test.assertEqualsList(list, simpleInstance.getDirectOwnSlotValues(slot));
        MergingNarrowFrameStore mergingNarrowFrameStore = this.getMergingFrameStore();
        String string = mergingNarrowFrameStore.getActiveFrameStore().getName();
        mergingNarrowFrameStore.addActiveFrameStore(new InMemoryFrameDb("parent"));
        mergingNarrowFrameStore.addRelation("parent", string);
        MergingNarrowFrameStore_Test.assertEqualsList(list, simpleInstance.getDirectOwnSlotValues(slot));
        List list2 = MergingNarrowFrameStore_Test.makeList("foo", "bar", "baz");
        simpleInstance.setOwnSlotValues(slot, list2);
        MergingNarrowFrameStore_Test.assertEqualsSet(list2, simpleInstance.getDirectOwnSlotValues(slot));
    }

    public void testGetCounts() {
        int n = this.getFrameCount();
        this.createCls();
        MergingNarrowFrameStore_Test.assertEquals((int)(n + 1), (int)this.getFrameCount());
        MergingNarrowFrameStore mergingNarrowFrameStore = this.getMergingFrameStore();
        String string = mergingNarrowFrameStore.getActiveFrameStore().getName();
        mergingNarrowFrameStore.addActiveFrameStore(new InMemoryFrameDb("child"));
        mergingNarrowFrameStore.addRelation(string, "child");
        this.createCls();
        mergingNarrowFrameStore.setActiveFrameStore(string);
        MergingNarrowFrameStore_Test.assertEquals((int)(n + 2), (int)this.getFrameCount());
        this.createCls();
        MergingNarrowFrameStore_Test.assertEquals((int)(n + 3), (int)this.getFrameCount());
    }

    public void testInterleavedValues() {
        Cls cls = this.createCls();
        Slot slot = this.createSlotOnCls(cls);
        SimpleInstance simpleInstance = this.createSimpleInstance(cls);
        List list = MergingNarrowFrameStore_Test.makeList("a", "b", "c");
        simpleInstance.setOwnSlotValues(slot, list);
        MergingNarrowFrameStore mergingNarrowFrameStore = this.getMergingFrameStore();
        NarrowFrameStore narrowFrameStore = mergingNarrowFrameStore.getActiveFrameStore();
        mergingNarrowFrameStore.addActiveFrameStore(new InMemoryFrameDb("parent"));
        mergingNarrowFrameStore.addRelation("parent", narrowFrameStore.getName());
        MergingNarrowFrameStore_Test.assertEqualsList(list, simpleInstance.getOwnSlotValues(slot));
        simpleInstance.setOwnSlotValues(slot, MergingNarrowFrameStore_Test.makeList("c", "d", "e", "f"));
        List list2 = MergingNarrowFrameStore_Test.makeList("a", "b", "c", "d", "e", "f");
        MergingNarrowFrameStore_Test.assertEqualsList(list2, simpleInstance.getOwnSlotValues(slot));
        simpleInstance.moveDirectOwnSlotValue(slot, 1, 3);
        MergingNarrowFrameStore_Test.assertEqualsList(list2, simpleInstance.getOwnSlotValues(slot));
        simpleInstance.moveDirectOwnSlotValue(slot, 4, 1);
        MergingNarrowFrameStore_Test.assertEqualsList(list2, simpleInstance.getOwnSlotValues(slot));
        simpleInstance.moveDirectOwnSlotValue(slot, 3, 4);
        MergingNarrowFrameStore_Test.assertEqualsList(MergingNarrowFrameStore_Test.makeList("a", "b", "c", "e", "d", "f"), simpleInstance.getOwnSlotValues(slot));
    }
}

