/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.framestore.AbstractFrameStoreInvocationHandler;
import edu.stanford.smi.protege.util.Log;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class TraceFrameStoreHandler
extends AbstractFrameStoreInvocationHandler {
    private Map methodCounts = new HashMap();

    public Object handleInvoke(Method method, Object[] objectArray) {
        Object object = this.invoke(method, objectArray);
        this.trace(method, objectArray);
        return object;
    }

    private void trace(Method method, Object[] objectArray) {
        Integer n = (Integer)this.methodCounts.get(method);
        Integer n2 = n == null ? new Integer(1) : new Integer(n + 1);
        this.methodCounts.put(method, n2);
        TraceFrameStoreHandler.print(n2, method, objectArray);
    }

    public static void print(int n, Method method, Object[] objectArray) {
        Log.getLogger().info(n + " " + method.getName() + " " + TraceFrameStoreHandler.argString(objectArray));
    }

    private static String argString(Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof Frame) {
                    object = ((Frame)object).getFrameID();
                }
                stringBuffer.append(object);
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }
}

