/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.log;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.DIGErrorExceptionLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.DefaultConceptConsistencyLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ErrorMessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.InformationMessageLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.OWLInstanceLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.WarningMessageLogRecord;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;

public class ReasonerLogRecordFactory {
    private static ReasonerLogRecordFactory instance;

    protected ReasonerLogRecordFactory() {
    }

    public static synchronized ReasonerLogRecordFactory getInstance() {
        if (instance == null) {
            instance = new ReasonerLogRecordFactory();
        }
        return instance;
    }

    public ReasonerLogRecord createInformationMessageLogRecord(String message, ReasonerLogRecord parent) {
        return new InformationMessageLogRecord(null, message, parent);
    }

    public ReasonerLogRecord createWarningMessageLogRecord(RDFResource cause, String message, ReasonerLogRecord parent) {
        return new WarningMessageLogRecord(cause, message, parent);
    }

    public ReasonerLogRecord createErrorMessageLogRecord(String message, ReasonerLogRecord parent) {
        return new ErrorMessageLogRecord(null, message, parent);
    }

    public ReasonerLogRecord createConceptConsistencyLogRecord(RDFSClass aClass, boolean consistent, ReasonerLogRecord parent) {
        return new DefaultConceptConsistencyLogRecord(aClass, consistent, parent);
    }

    public ReasonerLogRecord createOWLInstanceLogRecord(RDFResource instance, ReasonerLogRecord parent) {
        return new OWLInstanceLogRecord(instance, parent);
    }

    public ReasonerLogRecord createDIGReasonerExceptionLogRecord(DIGReasonerException ex, ReasonerLogRecord parent) {
        return new DIGErrorExceptionLogRecord(ex, parent);
    }
}

