/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.protegeowl.task;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGReasonerException;
import edu.stanford.smi.protegex.owl.inference.dig.translator.DIGQueryResponse;
import edu.stanford.smi.protegex.owl.inference.protegeowl.ProtegeOWLReasoner;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecord;
import edu.stanford.smi.protegex.owl.inference.protegeowl.log.ReasonerLogRecordFactory;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.AbstractReasonerTask;
import edu.stanford.smi.protegex.owl.inference.protegeowl.task.BooleanResultReasonerTask;
import edu.stanford.smi.protegex.owl.inference.util.TimeDifference;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import java.util.Iterator;
import org.w3c.dom.Document;

public class GetConceptSatisfiableTask
extends AbstractReasonerTask
implements BooleanResultReasonerTask {
    private OWLClass aClass;
    private ProtegeOWLReasoner protegeOWLReasoner;
    private boolean satisfiable;

    public GetConceptSatisfiableTask(OWLClass aClass, ProtegeOWLReasoner protegeOWLReasoner) {
        super(protegeOWLReasoner);
        this.aClass = aClass;
        this.protegeOWLReasoner = protegeOWLReasoner;
        this.satisfiable = true;
    }

    public int getTaskSize() {
        return 1;
    }

    public void run() throws DIGReasonerException {
        OWLModel kb = this.protegeOWLReasoner.getKnowledgeBase();
        ReasonerLogRecordFactory logRecordFactory = ReasonerLogRecordFactory.getInstance();
        ReasonerLogRecord parentRecord = logRecordFactory.createInformationMessageLogRecord("Checking consistency of " + this.aClass.getBrowserText(), null);
        this.postLogRecord(parentRecord);
        this.setDescription("Computing consistency");
        this.setMessage("Building reasoner query...");
        Document doc = this.getTranslator().createAsksDocument(this.protegeOWLReasoner.getReasonerKnowledgeBaseURI());
        this.getTranslator().createSatisfiableQuery(doc, "q0", this.aClass);
        this.setMessage("Querying reasoner...");
        TimeDifference td = new TimeDifference();
        td.markStart();
        Document responseDoc = this.protegeOWLReasoner.getDIGReasoner().performRequest(doc);
        td.markEnd();
        this.postLogRecord(logRecordFactory.createInformationMessageLogRecord("Time to query reasoner = " + td, parentRecord));
        Iterator it = this.getTranslator().getDIGQueryResponseIterator(kb, responseDoc);
        if (it.hasNext()) {
            DIGQueryResponse response = (DIGQueryResponse)it.next();
            this.satisfiable = response.getBoolean();
        }
        this.postLogRecord(logRecordFactory.createConceptConsistencyLogRecord(this.aClass, this.satisfiable, parentRecord));
        this.setProgress(1);
        this.setMessage("Finished");
        this.setTaskCompleted();
    }

    public boolean getResult() {
        return this.satisfiable;
    }
}

