/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.javacode;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.javacode.JavaCodeGenerator;
import edu.stanford.smi.protegex.owl.javacode.JavaCodeGeneratorPanel;
import edu.stanford.smi.protegex.owl.javacode.ProjectBasedJavaCodeGeneratorOptions;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.AbstractOWLModelAction;
import java.util.logging.Level;

public class JavaCodeGeneratorAction
extends AbstractOWLModelAction {
    public static final String GROUP = "Java";

    public String getMenubarPath() {
        return String.valueOf(CODE_MENU) + "/" + GROUP;
    }

    public String getName() {
        return "Generate Protege-OWL Java Code...";
    }

    public void run(OWLModel owlModel) {
        ProjectBasedJavaCodeGeneratorOptions options = new ProjectBasedJavaCodeGeneratorOptions(owlModel);
        JavaCodeGeneratorPanel panel = new JavaCodeGeneratorPanel(options);
        if (ProtegeUI.getModalDialogFactory().showDialog(ProtegeUI.getTopLevelContainer(owlModel.getProject()), panel, this.getName(), 11) == 1) {
            panel.ok();
            JavaCodeGenerator creator = new JavaCodeGenerator(owlModel, options);
            try {
                creator.createAll();
                ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, "Java code successfully generated.");
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, "Could not create Java code:\n" + ex);
            }
        }
    }
}

