/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena;

import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.AnnotationProperty;
import com.hp.hpl.jena.ontology.DatatypeProperty;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.tidy.Checker;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.NodeIteratorImpl;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.ProtegeNames;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class Jena {
    public static final String DEFAULT_NAMESPACE_SEPARATOR = "#";
    public static final String OWL_DL = "DL";
    public static final String OWL_FULL = "Full";
    public static final String OWL_LITE = "Lite";
    public static final String XML_TAG_HIDDEN_PROPERTY = "edu.stanford.smi.protegex.owl.jena.XML-Tag-Hidden";
    private static final Set systemClasses = new HashSet();
    public static final String ROOT_FOLDER = "edu.stanford.smi.protegex.owl";
    public static final String DEFAULT_ONT_POLICY_FILE_PATH = new File(ProtegeOWL.getPluginFolder(), "ont-policy.rdf").toURI().toString();
    public static final String ONT_POLICY_PROPERTY = "edu.stanford.smi.protegex.owl.jena.loader.JenaLoader.ontPolicy";

    static {
        systemClasses.add(OWL.Class);
        systemClasses.add(OWL.ObjectProperty);
        systemClasses.add(OWL.DatatypeProperty);
        systemClasses.add(OWL.Nothing);
        systemClasses.add(OWL.Thing);
        systemClasses.add(OWL.DeprecatedClass);
        systemClasses.add(OWL.DeprecatedProperty);
    }

    private static void addRDFTypes(Hashtable table, OntProperty property) {
        ArrayList<Resource> types = new ArrayList<Resource>();
        ExtendedIterator it = property.listRDFTypes(true);
        while (it.hasNext()) {
            Resource type = (Resource)it.next();
            types.add(type);
        }
        table.put(property, types);
    }

    public static DatatypeProperty asDatatypeProperty(Resource resource) {
        OntModel ontModel = (OntModel)resource.getModel();
        return (DatatypeProperty)ontModel.getResource(resource.getURI()).as(DatatypeProperty.class);
    }

    public static OntClass asOntClass(Resource resource) {
        if (resource.canAs(OntClass.class)) {
            return (OntClass)resource.as(OntClass.class);
        }
        OntModel ontModel = (OntModel)resource.getModel();
        OntClass ontClass = ontModel.getOntClass(resource.getURI());
        if (ontClass == null) {
            throw new IllegalArgumentException("Could not create OntClass");
        }
        return ontClass;
    }

    public static ObjectProperty asObjectProperty(Resource resource) {
        OntModel ontModel = (OntModel)resource.getModel();
        return (ObjectProperty)ontModel.getResource(resource.getURI()).as(ObjectProperty.class);
    }

    public static OntProperty asOntProperty(Resource resource) {
        OntModel ontModel = (OntModel)resource.getModel();
        return ontModel.getOntProperty(resource.getURI());
    }

    public static boolean canAs(RDFNode resource, Resource type) {
        if (resource.canAs(OntResource.class)) {
            OntResource ontResource = (OntResource)resource.as(OntResource.class);
            if (ontResource.hasRDFType(type)) {
                return true;
            }
            if (type instanceof EnhNode && ((EnhNode)type).getGraph() != null && type.canAs(OntClass.class)) {
                OntClass c = (OntClass)type.as(OntClass.class);
                ExtendedIterator it = c.listSubClasses(true);
                while (it.hasNext()) {
                    Resource superClass = (Resource)it.next();
                    if (!Jena.canAs(resource, (Resource)((OntClass)superClass.as(OntClass.class)))) continue;
                    return true;
                }
            } else if (ontResource.getModel() instanceof OntModel) {
                OntModel ontModel = (OntModel)ontResource.getModel();
                return Jena.canAs((RDFNode)ontResource, ontModel.getResource(type.getURI()));
            }
        }
        return false;
    }

    public static boolean canAsDatatypeProperty(RDFNode resource) {
        return Jena.canAs(resource, OWL.DatatypeProperty);
    }

    public static boolean canAsOntClass(RDFNode resource) {
        return resource.canAs(OntClass.class) || Jena.canAs(resource, OWL.Class) || Jena.canAs(resource, RDFS.Class);
    }

    public static boolean canAsObjectProperty(RDFNode resource) {
        return Jena.canAs(resource, OWL.ObjectProperty);
    }

    public static boolean canAsOntProperty(RDFNode resource) {
        return Jena.canAs(resource, RDF.Property);
    }

    public static boolean canAsOWLProperty(RDFNode resource) {
        return Jena.canAsObjectProperty(resource) || Jena.canAsDatatypeProperty(resource);
    }

    public static Iterator cloneIt(Iterator it) {
        ArrayList list = new ArrayList();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list.iterator();
    }

    public static OntModel cloneOntModel(OntModel oldModel) {
        OntModelSpec spec = new OntModelSpec(OntModelSpec.OWL_MEM);
        spec.setReasoner(null);
        return Jena.cloneOntModel(oldModel, spec);
    }

    public static OntModel cloneOntModel(OntModel oldModel, OntModelSpec spec) {
        String ns = oldModel.getNsPrefixURI("");
        StringWriter stringWriter = new StringWriter();
        RDFWriter writer = oldModel.getWriter("RDF/XML-ABBREV");
        writer.setProperty("blockRules", (Object)"propertyAttr");
        writer.setProperty("relativeURIs", (Object)"same-document");
        writer.write(oldModel.getBaseModel(), (Writer)stringWriter, ns);
        try {
            stringWriter.close();
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
        String buffer = stringWriter.toString();
        OntModel newModel = ModelFactory.createOntologyModel((OntModelSpec)spec, null);
        StringReader reader = new StringReader(buffer);
        newModel.read((Reader)reader, ns, "RDF/XML-ABBREV");
        try {
            ((Reader)reader).close();
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
        }
        return newModel;
    }

    public static Hashtable convertTypedAnnotationPropertiesIntoUntyped(OntModel ontModel) {
        DatatypeProperty property2;
        Hashtable result = new Hashtable();
        Resource annotationPropertyClass = ontModel.getProfile().ANNOTATION_PROPERTY();
        Object it = ontModel.listDatatypeProperties();
        while (it.hasNext()) {
            property2 = (DatatypeProperty)it.next();
            if (!property2.canAs(AnnotationProperty.class)) continue;
            Jena.addRDFTypes(result, (OntProperty)property2);
        }
        it = ontModel.listObjectProperties();
        while (it.hasNext()) {
            property2 = (ObjectProperty)it.next();
            if (!property2.canAs(AnnotationProperty.class)) continue;
            Jena.addRDFTypes(result, (OntProperty)property2);
        }
        for (DatatypeProperty property2 : result.keySet()) {
            List types = (List)result.get(property2);
            for (Resource type : types) {
                if (type.equals((Object)annotationPropertyClass)) continue;
                property2.removeRDFType(type);
                System.out.println("Temporarily removed type " + type + " from " + property2);
            }
        }
        return result;
    }

    public static void copyPropertyValues(Resource from, Resource to) {
        StmtIterator it = from.listProperties();
        while (it.hasNext()) {
            Property property = (Property)it.next();
            StmtIterator pit = from.listProperties(property);
            while (pit.hasNext()) {
                Statement s = pit.nextStatement();
                to.addProperty(property, s.getObject());
            }
        }
    }

    public static void dumpRDF(OntModel ontModel) {
        Jena.dumpRDF(ontModel, System.out);
    }

    public static void dumpRDF(OntModel ontModel, OutputStream stream) {
        String language = "RDF/XML-ABBREV";
        String namespace = ontModel.getNsPrefixURI("");
        RDFWriter writer = ontModel.getWriter(language);
        Jena.prepareWriter(writer, language, namespace);
        writer.write(ontModel.getBaseModel(), stream, namespace);
    }

    public static void dumpRDFTopLevel(OntModel ontModel) {
        String language = "RDF/XML-ABBREV";
        String namespace = ontModel.getNsPrefixURI("");
        RDFWriter writer = ontModel.getWriter(language);
        Jena.prepareWriter(writer, language, namespace);
        writer.write((Model)ontModel, (OutputStream)System.out, namespace);
    }

    public static Model addOWLFullModel(OntModel ontModel) {
        Model newModel = ModelFactory.createDefaultModel();
        newModel.add(OWL.Thing, RDF.type, (RDFNode)OWL.Class);
        newModel.add(OWL.Nothing, RDF.type, (RDFNode)OWL.Class);
        newModel.add(OWL.Class, RDF.type, (RDFNode)OWL.Class);
        newModel.add(RDF.Property, RDF.type, (RDFNode)OWL.Class);
        newModel.add(OWL.DatatypeProperty, RDF.type, (RDFNode)OWL.Class);
        newModel.add(OWL.ObjectProperty, RDF.type, (RDFNode)OWL.Class);
        newModel.add(RDFS.Class, RDF.type, (RDFNode)OWL.Class);
        newModel.add(RDF.List, RDF.type, (RDFNode)OWL.Class);
        newModel.add((Resource)RDF.first, RDF.type, (RDFNode)OWL.ObjectProperty);
        newModel.add((Resource)RDF.rest, RDF.type, (RDFNode)OWL.ObjectProperty);
        newModel.add(RDF.nil, RDF.type, (RDFNode)RDF.List);
        newModel.add((Resource)OWL.oneOf, RDF.type, (RDFNode)RDF.Property);
        newModel.add(RDFS.Literal, RDF.type, (RDFNode)OWL.Class);
        newModel.add(RDF.Statement, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(RDFS.Container, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(RDFS.Datatype, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.AllDifferent, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.DataRange, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.DeprecatedClass, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.DeprecatedClass, RDFS.subClassOf, (RDFNode)RDFS.Class);
        newModel.add(OWL.DeprecatedProperty, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.DeprecatedProperty, RDFS.subClassOf, (RDFNode)RDF.Property);
        newModel.add(OWL.AnnotationProperty, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.FunctionalProperty, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.InverseFunctionalProperty, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.SymmetricProperty, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.TransitiveProperty, RDF.type, (RDFNode)RDFS.Class);
        newModel.add(OWL.Ontology, RDF.type, (RDFNode)OWL.Class);
        newModel.add(newModel.getResource(String.valueOf(RDFS.getURI()) + "Alt"), RDF.type, (RDFNode)RDFS.Class);
        newModel.add(newModel.getResource(String.valueOf(RDFS.getURI()) + "Bag"), RDF.type, (RDFNode)RDFS.Class);
        newModel.add(newModel.getResource(String.valueOf(RDFS.getURI()) + "Seq"), RDF.type, (RDFNode)RDFS.Class);
        newModel.add((Resource)RDF.type, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDF.value, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDF.subject, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDF.predicate, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDF.object, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.sameAs, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.differentFrom, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.subClassOf, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.subPropertyOf, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.equivalentProperty, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.domain, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.range, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.seeAlso, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.isDefinedBy, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.complementOf, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.intersectionOf, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.unionOf, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.imports, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)newModel.createProperty("http://www.w3.org/2002/07/owl#valuesFrom"), RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.comment, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.isDefinedBy, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.label, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)RDFS.seeAlso, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.backwardCompatibleWith, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.incompatibleWith, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.priorVersion, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.versionInfo, RDF.type, (RDFNode)RDF.Property);
        newModel.add((Resource)OWL.onProperty, RDF.type, (RDFNode)RDF.Property);
        ontModel.addSubModel(newModel);
        return newModel;
    }

    public static void ensureOWLFullModelIsLastModel(OntModel ontModel, Model owlFullModel) {
        ontModel.removeSubModel(owlFullModel);
        ontModel.addSubModel(owlFullModel);
    }

    public static Graph getHomeGraph(OntModel ontModel, OntResource resource) {
        Property predicate = RDF.type;
        Resource object = resource.getRDFType();
        for (Graph graph : ontModel.getSubGraphs()) {
            if (!graph.contains(resource.getNode(), predicate.getNode(), object.getNode())) continue;
            return graph;
        }
        return ontModel.getGraph();
    }

    public static String getImportSource(OntModel ontModel, OntResource resource) {
        Graph homeGraph = Jena.getHomeGraph(ontModel, resource);
        if (homeGraph != null) {
            return homeGraph.getPrefixMapping().getNsPrefixURI("");
        }
        return null;
    }

    public static int getOWLSpecies(OntModel ontModel) {
        Checker checker = new Checker(false);
        checker.addGraphAndImports(ontModel.getGraph());
        String sublanguage = checker.getSubLanguage();
        if (sublanguage.equalsIgnoreCase(OWL_FULL)) {
            return 2;
        }
        if (sublanguage.equalsIgnoreCase(OWL_DL)) {
            return 1;
        }
        return 0;
    }

    public static String getOWLSpeciesString(int x) {
        if (x == 1) {
            return OWL_DL;
        }
        if (x == 0) {
            return OWL_LITE;
        }
        if (x == 2) {
            return OWL_FULL;
        }
        throw new IllegalArgumentException("Species constant must be on of OntModelProvider.OWL_xxx");
    }

    public static String getNamespaceFromURI(String namespace) {
        if (namespace.startsWith("urn:")) {
            if (!namespace.endsWith(":")) {
                namespace = String.valueOf(namespace) + ":";
            }
        } else if (!namespace.endsWith("/") && !namespace.endsWith(DEFAULT_NAMESPACE_SEPARATOR)) {
            namespace = String.valueOf(namespace) + DEFAULT_NAMESPACE_SEPARATOR;
        }
        return namespace;
    }

    public static String getNamespaceWithoutSeparator(String namespace) {
        return namespace.substring(0, namespace.length() - 1);
    }

    public static String getURIFromNamespace(String namespace) {
        if (namespace.length() > 1 && (namespace.endsWith(DEFAULT_NAMESPACE_SEPARATOR) || namespace.startsWith("urn:") && namespace.endsWith(":"))) {
            namespace = namespace.substring(0, namespace.length() - 1);
        }
        return namespace;
    }

    public static boolean isDatatypeProperty(OntModel ontModel, OntProperty ontProperty) {
        Resource datatypePropertyClass = ontModel.getResource(OWL.DatatypeProperty.getURI());
        return Jena.canAs((RDFNode)ontProperty, datatypePropertyClass);
    }

    public static boolean isImportedResource(OntModel ontModel, Model owlFullModel, OntResource ontResource) {
        Node subjectNode = ontResource.getNode();
        Node predicateNode = RDF.type.getNode();
        if (ontResource.getRDFType() != null) {
            Node objectNode = ontResource.getRDFType().getNode();
            Model baseModel = ontModel.getBaseModel();
            if (baseModel.getGraph().contains(subjectNode, predicateNode, objectNode)) {
                return false;
            }
            ArrayList subs = new ArrayList(ontModel.getSubGraphs());
            subs.remove(baseModel.getGraph());
            for (Graph graph : subs) {
                if (!graph.contains(subjectNode, predicateNode, objectNode)) continue;
                return true;
            }
        }
        return false;
    }

    private static Resource getBestType(OntResource resource) {
        ExtendedIterator it = resource.listRDFTypes(true);
        Resource result = (Resource)it.next();
        while (it.hasNext()) {
            String ns = result.getNameSpace();
            if (!ns.equals(OWL.getURI().toString()) && !ns.equals(RDFS.getURI().toString()) && !ns.equals(RDF.getURI().toString())) break;
            result = (Resource)it.next();
        }
        return result;
    }

    public static boolean isNamespaceWithSeparator(String str) {
        if (str.length() > 0 && Util.splitNamespace((String)str) == str.length()) {
            try {
                new URI(str);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isObjectProperty(OntModel ontModel, OntProperty ontProperty) {
        Resource objectPropertyClass = ontModel.getResource(OWL.ObjectProperty.getURI());
        return Jena.canAs((RDFNode)ontProperty, objectPropertyClass);
    }

    public static boolean isSystemProperty(OntProperty property) {
        return Jena.isSystemResource((Resource)property) || property.hasDomain(OWL.Class) && property.getNameSpace().equals("http://www.w3.org/2002/07/owl#");
    }

    public static boolean isSystemResource(Resource ontResource) {
        String nameSpace = ontResource.getNameSpace();
        return nameSpace.equals(ProtegeNames.NS) && !"defaultLanguage".equals(ontResource.getLocalName()) && !"usedLanguage".equals(ontResource.getLocalName()) && !"todoPrefix".equals(ontResource.getLocalName()) && !"todoProperty".equals(ontResource.getLocalName()) && !"readOnly".equals(ontResource.getLocalName()) || nameSpace.equals(OWL.getURI()) || nameSpace.equals(RDFS.getURI()) || nameSpace.equals(RDF.getURI());
    }

    public static boolean isSystemClass(OntClass ontClass) {
        return systemClasses.contains(ontClass) || ontClass.getNameSpace().equals(ProtegeNames.NS);
    }

    public static boolean isValidNamespace(String text) {
        if (Jena.isNamespaceWithSeparator(text) && (text.startsWith("http:") || text.startsWith("urn:") || text.startsWith("file:"))) {
            try {
                URI uri = new URI(text);
                return uri.isAbsolute();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isXMLLanguage(String language) {
        return "RDF/XML-ABBREV".equals(language) || "RDF/XML".equals(language);
    }

    public static boolean isXMLTagHidden() {
        return ApplicationProperties.getBooleanProperty((String)XML_TAG_HIDDEN_PROPERTY, (boolean)false);
    }

    public static boolean namespaceEndsWithSeparator(String namespace) {
        return namespace.endsWith(DEFAULT_NAMESPACE_SEPARATOR) || namespace.endsWith(":");
    }

    public static void prepareWriter(RDFWriter writer, String language, String namespace) {
        if ("RDF/XML-ABBREV".equals(language) || "RDF/XML".equals(language)) {
            writer.setProperty("showXmlDeclaration", (Object)("" + !Jena.isXMLTagHidden()));
            writer.setProperty("relativeURIs", (Object)"same-document");
            String xmlBase = namespace;
            if (Jena.isNamespaceWithSeparator(xmlBase) && !namespace.endsWith("/")) {
                xmlBase = xmlBase.substring(0, xmlBase.length() - 1);
            }
            writer.setProperty("xmlbase", (Object)xmlBase);
            if ("RDF/XML-ABBREV".equals(language)) {
                writer.setProperty("blockRules", (Object)"propertyAttr");
            }
        }
    }

    public static void removePropertyValue(OntResource resource, Property property, String value) {
        StmtIterator it = resource.listProperties(property);
        while (it.hasNext()) {
            Statement statement = it.nextStatement();
            RDFNode rdfNode = statement.getObject();
            if (!rdfNode.toString().equals(value)) continue;
            resource.removeProperty(property, rdfNode);
            return;
        }
    }

    public static Resource renameResource(Resource old, String uri, Model owlFullModel) {
        OntModel homeModel = (OntModel)old.getModel();
        Resource res = uri == null ? homeModel.createResource() : homeModel.createResource(uri);
        Model m = homeModel.getBaseModel();
        Jena.renameResourceInModel(m, old, res);
        if (owlFullModel != null) {
            Jena.renameResourceInModel(owlFullModel, old, res);
        }
        return res;
    }

    public static Resource renameResource(OntModel ontModel, Resource old, String uri) {
        OntModel homeModel = (OntModel)old.getModel();
        Resource res = uri == null ? homeModel.createResource() : homeModel.createResource(uri);
        Jena.renameResourceInGraph(ontModel.getBaseModel().getGraph(), old, res);
        for (Graph graph : ontModel.getSubGraphs()) {
            Jena.renameResourceInGraph(graph, old, res);
        }
        return res;
    }

    public static void renameResourceInGraph(Graph graph, Resource old, Resource newResource) {
        ArrayList stmts = new ArrayList();
        Object i = graph.find(old.getNode(), null, null);
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        i = graph.find(null, null, old.getNode());
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        for (Triple triple : stmts) {
            graph.delete(triple);
            Node subj = triple.getSubject().equals((Object)old.getNode()) ? newResource.getNode() : triple.getSubject();
            Node obj = triple.getObject().equals((Object)old.getNode()) ? newResource.getNode() : triple.getObject();
            graph.add(new Triple(subj, triple.getPredicate(), obj));
        }
    }

    public static void renameResourceInModel(Model m, Resource old, Resource newResource) {
        ArrayList stmts = new ArrayList();
        Object i = m.listStatements(old, null, null);
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        i = m.listStatements(null, null, (RDFNode)old);
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        for (Statement s : stmts) {
            s.remove();
            Resource subj = s.getSubject().equals((Object)old) ? newResource : s.getSubject();
            Resource obj = s.getObject().equals(old) ? newResource : s.getObject();
            m.add(subj, s.getPredicate(), (RDFNode)obj);
        }
    }

    public static void saveOntModel(OWLModel owlModel, File file, OntModel owldlOntModel, String message) {
        try {
            String language = "RDF/XML-ABBREV";
            FileOutputStream outputStream = new FileOutputStream(file);
            PrintStream ps = new PrintStream(outputStream);
            String namespace = owldlOntModel.getNsPrefixURI("");
            RDFWriter writer = owldlOntModel.getWriter(language);
            Jena.prepareWriter(writer, language, namespace);
            writer.write(owldlOntModel.getBaseModel(), (OutputStream)ps, namespace);
            ((OutputStream)outputStream).close();
            ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, message);
        }
        catch (IOException ex) {
            ProtegeUI.getModalDialogFactory().showThrowable(owlModel, ex);
        }
    }

    public static Set set(Iterator it) {
        HashSet result = new HashSet();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static void set(Set set, Iterator it) {
        while (it.hasNext()) {
            set.add(it.next());
        }
    }

    public static void setXMLTagHidden(boolean value) {
        ApplicationProperties.setString((String)XML_TAG_HIDDEN_PROPERTY, (String)("" + value));
    }

    public static RDFNode getPropertyValue(Resource resource, Property property) {
        NodeIterator it = Jena.listPropertyValues(resource, property);
        if (it.hasNext()) {
            return it.nextNode();
        }
        return null;
    }

    public static NodeIterator listPropertyValues(Resource resource, Property property) {
        return new NodeIteratorImpl((Iterator)resource.listProperties(property).mapWith((Map1)new ObjectMapper()), null);
    }

    public static Collection getDirectSubClasses(OntClass ontClass) {
        ArrayList<OntClass> result = new ArrayList<OntClass>();
        ExtendedIterator it = ontClass.listSubClasses(true);
        while (it.hasNext()) {
            OntClass subClass = (OntClass)it.next();
            if (subClass.equals((Object)ontClass)) continue;
            result.add(subClass);
        }
        return result;
    }

    public static Collection getDirectSuperClasses(OntClass ontClass) {
        ArrayList<OntClass> result = new ArrayList<OntClass>();
        ExtendedIterator it = ontClass.listSuperClasses(true);
        while (it.hasNext()) {
            OntClass superClass = (OntClass)it.next();
            if (superClass.equals((Object)ontClass)) continue;
            result.add(superClass);
        }
        return result;
    }

    public static Ontology getDefaultJenaOntology(String namespace, OntModel ontModel) {
        if (namespace.endsWith(DEFAULT_NAMESPACE_SEPARATOR)) {
            namespace = Jena.getNamespaceWithoutSeparator(namespace);
        }
        ExtendedIterator it = ontModel.listOntologies();
        while (it.hasNext()) {
            Ontology ontology = (Ontology)it.next();
            String ns = ontology.getURI();
            if (!namespace.equals(ns)) continue;
            return ontology;
        }
        return null;
    }

    public static String getOntPolicyFilePath(Project project) {
        if (project == null) {
            return DEFAULT_ONT_POLICY_FILE_PATH;
        }
        String str = project.getSources().getString(ONT_POLICY_PROPERTY);
        if (str == null) {
            return DEFAULT_ONT_POLICY_FILE_PATH;
        }
        return str;
    }

    public static void setOntPolicyFilePath(Project project, String path) {
        project.getSources().setString(ONT_POLICY_PROPERTY, path);
    }

    public static void removePropertyValue(Resource resource, Property property, RDFNode value) {
        StmtIterator i = resource.getModel().listStatements(resource, property, value);
        if (i.hasNext()) {
            i.nextStatement().remove();
        }
        i.close();
    }

    protected static class ObjectMapper
    implements Map1 {
        protected ObjectMapper() {
        }

        public Object map1(Object x) {
            return x instanceof Statement ? ((Statement)x).getObject() : x;
        }
    }
}

