/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model;

import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.model.TaskManager;

public abstract class AbstractTask
implements Task {
    private boolean cancelled;
    private String title;
    private boolean canBeCancelled;
    private TaskManager tm;
    private int progMin;
    private int progMax;

    public AbstractTask(String title, boolean canBeCancelled, TaskManager tm) {
        this(title, canBeCancelled, tm, 0, 100);
    }

    public AbstractTask(String title, boolean canBeCancelled, TaskManager tm, int progMin, int progMax) {
        this.title = title;
        this.canBeCancelled = canBeCancelled;
        this.tm = tm;
        this.progMin = progMin;
        this.progMax = progMax;
    }

    public boolean isPossibleToCancel() {
        return this.canBeCancelled;
    }

    public void cancelTask() {
        this.cancelled = true;
    }

    public String getTitle() {
        return this.title;
    }

    public int getProgressMin() {
        return this.progMin;
    }

    public int getProgressMax() {
        return this.progMax;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setProgress(int value) {
        this.tm.setProgress(this, value);
    }

    public void setProgressIndeterminate(boolean b) {
        this.tm.setIndeterminate(this, true);
    }

    public void setMessage(String message) {
        this.tm.setMessage(this, message);
    }
}

