/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.factory;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.DefaultFrameFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDataRange;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIndividual;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFList;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFUntypedResource;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;

public class OWLJavaFactory
extends DefaultFrameFactory {
    private static Hashtable<String, String> clsNames = new Hashtable();
    private static final String CLASSNAME_PREFIX = "edu.stanford.smi.protegex.owl.model.impl.Default";
    private AbstractOWLModel owlModel;

    static {
        clsNames.put("owl:Class", "OWLNamedClass");
        clsNames.put("rdf:Property", "RDFProperty");
        clsNames.put("rdfs:Class", "RDFSNamedClass");
        clsNames.put("owl:EnumeratedClass", "OWLEnumeratedClass");
        clsNames.put("owl:AllValuesFromRestriction", "OWLAllValuesFrom");
        clsNames.put("owl:SomeValuesFromRestriction", "OWLSomeValuesFrom");
        clsNames.put("owl:HasValueRestriction", "OWLHasValue");
        clsNames.put("owl:MaxCardinalityRestriction", "OWLMaxCardinality");
        clsNames.put("owl:MinCardinalityRestriction", "OWLMinCardinality");
        clsNames.put("owl:CardinalityRestriction", "OWLCardinality");
        clsNames.put("owl:ComplementClass", "OWLComplementClass");
        clsNames.put("owl:IntersectionClass", "OWLIntersectionClass");
        clsNames.put("owl:UnionClass", "OWLUnionClass");
        clsNames.put("owl:AllDifferent", "OWLAllDifferent");
        clsNames.put("protege:ExternalResource", "RDFUntypedResource");
        clsNames.put("rdfs:Datatype", "RDFSDatatype");
        clsNames.put("owl:DataRange", "OWLDataRange");
        clsNames.put("rdf:List", "RDFList");
        clsNames.put("owl:Ontology", "OWLOntology");
        clsNames.put("owl:DatatypeProperty", "OWLDatatypeProperty");
        clsNames.put("owl:ObjectProperty", "OWLObjectProperty");
    }

    public OWLJavaFactory(AbstractOWLModel owlModel) {
        super((KnowledgeBase)owlModel);
        this.owlModel = owlModel;
    }

    public RDFResource as(RDFResource resource, Class javaInterface) {
        if (javaInterface.isAssignableFrom(resource.getClass())) {
            return resource;
        }
        Constructor con = this.getImplementationConstructor(javaInterface);
        try {
            return (RDFResource)con.newInstance(resource.getOWLModel(), resource.getFrameID());
        }
        catch (Exception ex) {
            System.err.println("[OWLJavaFactory] Fatal Error: Could not create Java object for " + javaInterface);
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            return resource;
        }
    }

    public boolean canAs(RDFResource resource, Class javaInterface) {
        if (javaInterface.isAssignableFrom(resource.getClass())) {
            return true;
        }
        HashSet<RDFSClass> clses = new HashSet<RDFSClass>();
        for (RDFSClass type : resource.getProtegeTypes()) {
            clses.add(type);
            clses.addAll(type.getSuperclasses(true));
        }
        String matchName = javaInterface.getName();
        matchName = matchName.substring(matchName.lastIndexOf(46) + 1);
        for (RDFSClass type : clses) {
            String name;
            if (!(type instanceof RDFSNamedClass) || !(name = this.getJavaInterfaceName(type)).equals(matchName)) continue;
            return true;
        }
        return false;
    }

    public String getImplementationClassName(Class javaInterface) {
        String name = javaInterface.getName();
        int lastDot = name.lastIndexOf(".");
        String partialName = name.substring(lastDot + 1);
        return String.valueOf(name.substring(0, lastDot + 1)) + "impl.Default" + partialName;
    }

    public Class getImplementationClass(Class javaInterface) throws ClassNotFoundException {
        return Class.forName(this.getImplementationClassName(javaInterface));
    }

    public Constructor getImplementationConstructor(Class javaInterface) {
        try {
            Class c = this.getImplementationClass(javaInterface);
            try {
                return c.getConstructor(OWLModel.class, FrameID.class);
            }
            catch (Exception exception) {
                return c.getConstructor(KnowledgeBase.class, FrameID.class);
            }
        }
        catch (Exception ex) {
            Log.getLogger().severe("[OWLJavaFactory] Fatal Error: Could not find constructor for " + javaInterface);
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            return null;
        }
    }

    public String getJavaInterfaceName(RDFSClass cls) {
        String typeName = cls.getLocalName();
        StringBuffer className = new StringBuffer();
        int i = 0;
        while (i < typeName.length()) {
            char c = typeName.charAt(i);
            if (this.isValidCharacter(c, className.length())) {
                className.append(c);
            }
            ++i;
        }
        return className.toString();
    }

    public Cls createCls(FrameID id, Collection directTypes) {
        if (id.equals((Object)Model.ClsID.THING)) {
            return new DefaultOWLNamedClass(this.owlModel, id);
        }
        Cls rdfsClsMetaCls = this.owlModel.getRDFSClassMetaClassCls();
        Cls namedClsMetaCls = this.owlModel.getOWLNamedClassMetaClassCls();
        for (Instance metaCls : directTypes) {
            String metaClsName = metaCls.getName();
            String javaClassName = clsNames.get(metaClsName);
            if (javaClassName != null) {
                return this.createCls(javaClassName, id);
            }
            if (!metaCls.isSystem()) {
                if (metaCls instanceof Cls) {
                    if (((Cls)metaCls).hasSuperclass(namedClsMetaCls)) {
                        return new DefaultOWLNamedClass(this.owlModel, id);
                    }
                    if (!((Cls)metaCls).hasSuperclass(rdfsClsMetaCls)) continue;
                    return new DefaultRDFSNamedClass(this.owlModel, id);
                }
                return new DefaultOWLNamedClass(this.owlModel, id);
            }
            if (!metaCls.equals(this.owlModel.getOWLDeprecatedClassClass())) continue;
            return new DefaultRDFSNamedClass(this.owlModel, id);
        }
        return super.createCls(id, directTypes);
    }

    private Cls createCls(String javaClassName, FrameID id) {
        try {
            Class<?> clazz = Class.forName(CLASSNAME_PREFIX + javaClassName);
            Class[] parameterTypes = new Class[]{KnowledgeBase.class, FrameID.class};
            Constructor<?> constructor = clazz.getConstructor(parameterTypes);
            Object[] args = new Object[]{this.owlModel, id};
            return (Cls)constructor.newInstance(args);
        }
        catch (Exception ex) {
            System.err.println("Fatal Error: Could not create Cls from OWL metaclass " + javaClassName);
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            return new DefaultOWLNamedClass(this.owlModel, id);
        }
    }

    public SimpleInstance createSimpleInstance(FrameID id, Collection directTypes) {
        if (directTypes.contains(this.owlModel.getOWLAllDifferentClassCls())) {
            return new DefaultOWLAllDifferent(this.owlModel, id);
        }
        if (directTypes.contains(this.owlModel.getOWLDataRangeClass())) {
            return new DefaultOWLDataRange(this.owlModel, id);
        }
        if (directTypes.contains(this.owlModel.getRDFSDatatypeClass())) {
            return new DefaultRDFSDatatype(this.owlModel, id);
        }
        if (directTypes.contains(this.owlModel.getRDFUntypedResourcesClass())) {
            return new DefaultRDFUntypedResource(this.owlModel, id);
        }
        if (directTypes.contains(this.owlModel.getRDFListCls()) || directTypes.size() > 0 && ((Cls)directTypes.iterator().next()).hasSuperclass((Cls)this.owlModel.getRDFListClass())) {
            return new DefaultRDFList(this.owlModel, id);
        }
        if (directTypes.contains(this.owlModel.getOWLOntologyCls())) {
            return new DefaultOWLOntology(this.owlModel, id);
        }
        if (directTypes.size() == 0 || directTypes.toArray()[0] instanceof OWLClass) {
            return new DefaultOWLIndividual(this.owlModel, id);
        }
        return new DefaultRDFIndividual(this.owlModel, id);
    }

    public Slot createSlot(FrameID id, Collection directTypes) {
        OWLNamedClass datatypeSlotMetaCls = this.owlModel.getOWLDatatypePropertyClass();
        OWLNamedClass objectSlotMetaCls = this.owlModel.getOWLObjectPropertyClass();
        RDFSNamedClass rdfSlotMetaCls = this.owlModel.getRDFPropertyClass();
        for (Cls metaCls : directTypes) {
            if (metaCls.equals(datatypeSlotMetaCls) || metaCls.hasSuperclass((Cls)datatypeSlotMetaCls)) {
                return new DefaultOWLDatatypeProperty(this.owlModel, id);
            }
            if (metaCls.equals(objectSlotMetaCls) || metaCls.hasSuperclass((Cls)objectSlotMetaCls)) {
                return new DefaultOWLObjectProperty(this.owlModel, id);
            }
            if (!metaCls.equals(rdfSlotMetaCls) && !metaCls.hasSuperclass((Cls)rdfSlotMetaCls)) continue;
            return new DefaultRDFProperty(this.owlModel, id);
        }
        return super.createSlot(id, directTypes);
    }

    public boolean isCorrectJavaImplementationClass(FrameID id, Collection types, Class clas) {
        Cls namedClsMetaCls = this.owlModel.getOWLNamedClassMetaClassCls();
        Cls datatypeSlotMetaCls = this.owlModel.getOWLDatatypePropertyMetaClassCls();
        Cls objectSlotMetaCls = this.owlModel.getOWLObjectPropertyMetaClassCls();
        for (Cls metaCls : types) {
            String javaClassName = clsNames.get(metaCls.getName());
            if (javaClassName != null) {
                return clas.getName().equals(CLASSNAME_PREFIX + javaClassName);
            }
            if (metaCls.hasSuperclass(namedClsMetaCls)) {
                return clas.getName().equals("edu.stanford.smi.protegex.owl.model.impl.DefaultOWLNamedClass");
            }
            if (metaCls.hasSuperclass(datatypeSlotMetaCls)) {
                return clas.getName().equals("edu.stanford.smi.protegex.owl.model.impl.DefaultOWLDatatypeProperty");
            }
            if (!metaCls.hasSuperclass(objectSlotMetaCls)) continue;
            return clas.getName().equals("edu.stanford.smi.protegex.owl.model.impl.DefaultOWLObjectProperty");
        }
        return clas.getName().equals("edu.stanford.smi.protegex.owl.model.impl.DefaultRDFIndividual");
    }
}

