/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.factory;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.MergingNarrowFrameStore;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.jena.parser.ProtegeOWLParserException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class OWLJavaFactoryUpdater {
    private int count = 0;
    private Set metaclasses = new HashSet<E>();
    private Set metaslots = new HashSet<E>();
    private MergingNarrowFrameStore mnfs;

    public OWLJavaFactoryUpdater(KnowledgeBase kb) {
        this(kb, kb.getFrames());
    }

    /*
     * Unable to fully structure code
     */
    public OWLJavaFactoryUpdater(KnowledgeBase kb, Collection frames) {
        super();
        this.mnfs = MergingNarrowFrameStore.get((KnowledgeBase)kb);
        this.findMetaclasses(kb);
        instance = null;
        try {
            prog = 0;
            it = frames.iterator();
            while (it.hasNext()) {
                ++prog;
                instance = (Instance)it.next();
                newInstance = this.createNewFrame(instance);
                if (instance.getClass() == newInstance.getClass()) continue;
                this.mnfs.replaceFrame((Frame)newInstance);
            }
        }
        catch (ClassCastException ccx) {
            types = instance.getDirectTypes();
            ** for (type : types)
        }
lbl-1000:
        // 1 sources

        {
            if (type instanceof Cls) continue;
            throw new ProtegeOWLParserException("The resource " + instance.getName() + " has the rdf:type " + type.getName() + " which is not a class but a " + type.getClass().getName(), "In many cases the problem is a missing owl:imports statement to the classes file which defines the correct type of " + type.getName());
        }
lbl24:
        // 1 sources

        Log.getLogger().log(Level.SEVERE, "Exception caught", ccx);
        throw new RuntimeException("Failed to convert type of " + instance);
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            throw new RuntimeException("Failed to convert type of " + instance);
        }
        kb.flushCache();
    }

    public Instance createNewFrame(Instance instance) {
        if (this.isCls(instance)) {
            return instance.getKnowledgeBase().getFrameFactory().createCls(instance.getFrameID(), instance.getDirectTypes());
        }
        if (this.isSlot(instance)) {
            return instance.getKnowledgeBase().getFrameFactory().createSlot(instance.getFrameID(), instance.getDirectTypes());
        }
        if (!(instance instanceof Facet)) {
            return instance.getKnowledgeBase().getFrameFactory().createSimpleInstance(instance.getFrameID(), instance.getDirectTypes());
        }
        return instance;
    }

    private void findMetaclasses(KnowledgeBase kb) {
        this.findSubclasses(this.metaclasses, (Frame)kb.getCls(":CLASS"));
        this.findSubclasses(this.metaslots, (Frame)kb.getCls(":SLOT"));
    }

    private void findSubclasses(Set metaclasses, Frame frame) {
        metaclasses.add(frame);
        Slot directSubclassesSlot = frame.getKnowledgeBase().getSlot(":DIRECT-SUBCLASSES");
        List subclasses = this.mnfs.getValues(frame, directSubclassesSlot, null, false);
        for (Frame subclass : subclasses) {
            if (metaclasses.contains(subclass)) continue;
            this.findSubclasses(metaclasses, subclass);
        }
    }

    private boolean isCls(Instance instance) {
        Collection types = instance.getDirectTypes();
        for (Instance type : types) {
            if (type.equals(instance)) {
                if (this.metaclasses.contains(type)) {
                    return true;
                }
                this.metaclasses.add(type);
                this.updateFrame(type);
            }
            if (!(type instanceof Cls)) {
                this.updateFrame(type);
            }
            if (!this.metaclasses.contains(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isSlot(Instance instance) {
        Collection types = instance.getDirectTypes();
        for (Instance type : types) {
            if (!this.metaslots.contains(type)) continue;
            return true;
        }
        return false;
    }

    private void log(String message) {
        System.out.println("[OWLJavaFactoryUpdater] " + message);
    }

    public void updateFrame(Instance instance) {
        Instance newInstance = this.createNewFrame(instance);
        if (instance.getClass() != newInstance.getClass()) {
            this.mnfs.replaceFrame((Frame)newInstance);
        }
    }

    public static void run(Instance resource) {
        OWLJavaFactoryUpdater.run(resource.getKnowledgeBase(), Collections.singleton(resource));
    }

    public static void run(KnowledgeBase kb, Collection instances) {
        new OWLJavaFactoryUpdater(kb, instances);
    }

    public static void run(JenaOWLModel owlModel) {
        new OWLJavaFactoryUpdater(owlModel);
    }
}

