/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.XSD;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.AbstractNamespaceManager;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OWLNamespaceManager
extends AbstractNamespaceManager {
    public static final String DEFAULT_DEFAULT_BASE = "http://www.owl-ontologies.com/unnamed.owl";
    public static final String DEFAULT_DEFAULT_NAMESPACE = "http://www.owl-ontologies.com/unnamed.owl#";
    private String defaultNamespace;
    private Slot prefixesSlot;
    private Map namespace2Prefix = new HashMap();
    private Map prefix2Namespace = new HashMap();
    private Collection systemPrefixes = new ArrayList();

    private void addPrefixes(Instance ontology, boolean isDefaultOntology) {
        List values = ontology.getDirectOwnSlotValues(this.prefixesSlot);
        for (String value : values) {
            int index = value.indexOf(58);
            if (index <= 0 && !isDefaultOntology) continue;
            String prefix = value.substring(0, index);
            String namespace = value.substring(index + 1);
            this.addPrefix(prefix, namespace);
        }
    }

    private void addPrefix(String prefix, String namespace) {
        if (!this.prefix2Namespace.containsKey(prefix)) {
            this.prefix2Namespace.put(prefix, namespace);
        }
        this.namespace2Prefix.put(namespace, prefix);
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public String getNamespaceForPrefix(String prefix) {
        return (String)this.prefix2Namespace.get(prefix);
    }

    public String getPrefix(String namespace) {
        return (String)this.namespace2Prefix.get(namespace);
    }

    public Collection getPrefixes() {
        HashSet results = new HashSet(this.prefix2Namespace.keySet());
        results.remove("");
        return results;
    }

    public void init(OWLModel owlModel) {
        super.init(owlModel);
        this.prefixesSlot = owlModel.getSlot(":OWL-ONTOLOGY-PREFIXES");
        this.update();
    }

    public boolean isModifiable(String prefix) {
        return !this.systemPrefixes.contains(prefix);
    }

    public static boolean isValidPrefix(String prefix) {
        if (prefix.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(prefix.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < prefix.length()) {
            char c = prefix.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '.' && c != '-') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void removePrefix(String prefix) {
        this.removePrefixHelper(prefix);
        this.update();
        for (NamespaceManagerListener listener : new ArrayList(this.getListeners())) {
            listener.prefixRemoved(prefix);
        }
    }

    private void removePrefixHelper(String prefix) {
        String value = String.valueOf(prefix) + ":" + this.getNamespaceForPrefix(prefix);
        for (Instance curOntology : this.owlModel.getOWLOntologies()) {
            curOntology.removeOwnSlotValue(this.prefixesSlot, (Object)value);
        }
    }

    public void setDefaultNamespace(String value) {
        String oldValue = this.getDefaultNamespace();
        this.defaultNamespace = value;
        OWLOntology oi = this.owlModel.getDefaultOWLOntology();
        this.setDefaultNamespace(oi, value);
        for (NamespaceManagerListener listener : new ArrayList(this.getListeners())) {
            listener.defaultNamespaceChanged(oldValue, value);
        }
    }

    private void setDefaultNamespace(OWLOntology oi, String value) {
        List values = oi.getDirectOwnSlotValues(this.prefixesSlot);
        for (String str : values) {
            if (!str.startsWith(":")) continue;
            oi.removeOwnSlotValue(this.prefixesSlot, str);
            break;
        }
        oi.addOwnSlotValue(this.prefixesSlot, ":" + value);
        this.update();
    }

    public void setModifiable(String prefix, boolean value) {
        if (value) {
            this.systemPrefixes.remove(prefix);
        } else {
            this.systemPrefixes.add(prefix);
        }
    }

    public void setPrefix(String namespace, String prefix) {
        TripleStoreModel tsm = this.owlModel.getTripleStoreModel();
        TripleStore oldActiveTripleStore = tsm.getActiveTripleStore();
        tsm.setActiveTripleStore(tsm.getTopTripleStore());
        String oldPrefix = this.getPrefix(namespace);
        String oldNamespace = this.getNamespaceForPrefix(prefix);
        String value = String.valueOf(prefix) + ":" + namespace;
        OWLOntology oi = this.owlModel.getDefaultOWLOntology();
        if (oldNamespace != null) {
            this.removePrefixHelper(prefix);
            oi.addOwnSlotValue(this.prefixesSlot, value);
            tsm.setActiveTripleStore(oldActiveTripleStore);
            this.update();
            for (NamespaceManagerListener listener : new ArrayList(this.getListeners())) {
                listener.namespaceChanged(prefix, oldNamespace, namespace);
            }
        } else if (oldPrefix != null) {
            this.removePrefixHelper(oldPrefix);
            oi.addOwnSlotValue(this.prefixesSlot, value);
            tsm.setActiveTripleStore(oldActiveTripleStore);
            this.update();
            for (NamespaceManagerListener listener : new ArrayList(this.getListeners())) {
                listener.prefixChanged(namespace, oldPrefix, prefix);
            }
        } else {
            oi.addOwnSlotValue(this.prefixesSlot, value);
            tsm.setActiveTripleStore(oldActiveTripleStore);
            this.update();
            for (NamespaceManagerListener listener : new ArrayList(this.getListeners())) {
                listener.prefixAdded(prefix);
            }
        }
    }

    public void update() {
        this.prefix2Namespace.clear();
        this.namespace2Prefix.clear();
        this.installDefaultNamespaces();
        ArrayList ontologies = this.owlModel.getOWLOntologies();
        Instance defaultOntology = null;
        TripleStoreModel tsm = this.owlModel.getTripleStoreModel();
        if (!ontologies.isEmpty()) {
            if (tsm != null && this.owlModel instanceof JenaOWLModel) {
                TripleStore tripleStore = tsm.getTopTripleStore();
                defaultOntology = TripleStoreUtil.getFirstOntology(this.owlModel, tripleStore);
            } else {
                defaultOntology = (Instance)ontologies.iterator().next();
            }
        }
        if (defaultOntology != null) {
            this.addPrefixes(defaultOntology, true);
            ontologies = new ArrayList(ontologies);
            ontologies.remove(defaultOntology);
        }
        for (Instance ontology : ontologies) {
            this.addPrefixes(ontology, false);
        }
        this.defaultNamespace = this.getNamespaceForPrefix("");
        if (this.defaultNamespace == null) {
            this.defaultNamespace = DEFAULT_DEFAULT_NAMESPACE;
        }
    }

    private void installDefaultNamespaces() {
        this.addPrefix("owl", OWL.getURI());
        this.addPrefix("rdf", RDF.getURI());
        this.addPrefix("rdfs", RDFS.getURI());
        this.addPrefix("xsd", XSD.anyURI.getNameSpace());
    }
}

