/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;

public class GetReferringAnonymousClassesTestCase
extends AbstractJenaTestCase {
    public void testOWLComplementClass() {
        OWLNamedClass namedCls = this.owlModel.createOWLNamedClass("Person");
        OWLComplementClass complementCls = this.owlModel.createOWLComplementClass(namedCls);
        GetReferringAnonymousClassesTestCase.assertSize(1, namedCls.getReferringAnonymousClasses());
        GetReferringAnonymousClassesTestCase.assertContains((Object)complementCls, namedCls.getReferringAnonymousClasses());
    }

    public void testOWLEnumeratedClass() {
        OWLNamedClass aCls = this.owlModel.createOWLNamedClass("A");
        RDFResource a = aCls.createInstance("a");
        RDFIndividual b = aCls.createRDFIndividual("b");
        OWLEnumeratedClass enumeratedClass = this.owlModel.createOWLEnumeratedClass();
        enumeratedClass.addOneOf(a);
        enumeratedClass.addOneOf(b);
        GetReferringAnonymousClassesTestCase.assertSize(1, a.getReferringAnonymousClasses());
        GetReferringAnonymousClassesTestCase.assertContains((Object)enumeratedClass, a.getReferringAnonymousClasses());
    }

    public void testOWLMinCardinality() {
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        OWLMinCardinality restriction = this.owlModel.createOWLMinCardinality(slot, 1);
        GetReferringAnonymousClassesTestCase.assertSize(1, slot.getReferringAnonymousClasses());
        GetReferringAnonymousClassesTestCase.assertContains((Object)restriction, slot.getReferringAnonymousClasses());
    }

    public void testOWLUnionClass() {
        OWLNamedClass namedClass = this.owlModel.createOWLNamedClass("Person");
        OWLNamedClass otherClass = this.owlModel.createOWLNamedClass("Other");
        OWLUnionClass unionClass = this.owlModel.createOWLUnionClass();
        unionClass.addOperand(otherClass);
        unionClass.addOperand(namedClass);
        GetReferringAnonymousClassesTestCase.assertSize(1, namedClass.getReferringAnonymousClasses());
        GetReferringAnonymousClassesTestCase.assertContains((Object)unionClass, namedClass.getReferringAnonymousClasses());
    }
}

