/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Model;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLComplementClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLHasValue;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLUnionClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.Triple;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddAnonymousClassPropertyPropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddOWLInverseOfPropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddPropertyValueHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddRDFSSubClassOfPropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddRDFSSubPropertyOfPropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AddRDFTypePropertyHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.DefaultTriple;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.ProtegeTripleAdder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTripleStore
implements ProtegeTripleAdder,
TripleStore {
    private Map addPropertyValueHandlers = new HashMap();
    private Slot directInstancesSlot;
    private Slot directTypesSlot;
    protected NarrowFrameStore frameStore;
    protected Slot nameSlot;
    protected OWLModel owlModel;
    protected TripleStoreModel tripleStoreModel;

    public AbstractTripleStore(OWLModel owlModel, TripleStoreModel tripleStoreModel, NarrowFrameStore frameStore) {
        this.frameStore = frameStore;
        this.owlModel = owlModel;
        this.tripleStoreModel = tripleStoreModel;
        OWLModel kb = owlModel;
        this.directTypesSlot = kb.getSlot(":DIRECT-TYPE");
        this.directInstancesSlot = kb.getSlot(":DIRECT-INSTANCES");
        this.nameSlot = kb.getSlot(":NAME");
        this.initAACHandler("owl:complementOf", "owl:ComplementClass", DefaultOWLComplementClass.class);
        this.initAACHandler("owl:intersectionOf", "owl:IntersectionClass", DefaultOWLIntersectionClass.class);
        this.initAACHandler("owl:unionOf", "owl:UnionClass", DefaultOWLUnionClass.class);
        this.initAACHandler("owl:cardinality", "owl:CardinalityRestriction", DefaultOWLCardinality.class);
        this.initAACHandler("owl:minCardinality", "owl:MinCardinalityRestriction", DefaultOWLMinCardinality.class);
        this.initAACHandler("owl:maxCardinality", "owl:MaxCardinalityRestriction", DefaultOWLMaxCardinality.class);
        this.initAACHandler("owl:allValuesFrom", "owl:AllValuesFromRestriction", DefaultOWLAllValuesFrom.class);
        this.initAACHandler("owl:someValuesFrom", "owl:SomeValuesFromRestriction", DefaultOWLSomeValuesFrom.class);
        this.initAACHandler("owl:hasValue", "owl:HasValueRestriction", DefaultOWLHasValue.class);
        this.initHandler("owl:inverseOf", new AddOWLInverseOfPropertyHandler(this, kb));
        this.initHandler("rdfs:subClassOf", new AddRDFSSubClassOfPropertyHandler(this, kb));
        this.initHandler("rdfs:subPropertyOf", new AddRDFSSubPropertyOfPropertyHandler(this, kb));
        this.initHandler("rdf:type", new AddRDFTypePropertyHandler(this, kb, tripleStoreModel, this));
    }

    public void add(Triple triple) {
        this.add(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void add(RDFResource subject, RDFProperty predicate, Object object) {
        this.addValueFast(subject, predicate, object);
        AddPropertyValueHandler handler = (AddPropertyValueHandler)this.addPropertyValueHandlers.get(predicate);
        if (handler != null) {
            handler.handleAdd(subject, object);
        }
    }

    public boolean addValue(Instance subject, Slot slot, Object object) {
        Collection values = this.getValues(subject, slot);
        if (!values.contains(object)) {
            this.addValueFast(subject, slot, object);
            return true;
        }
        return false;
    }

    public void addValueFast(Instance subject, Slot slot, Object object) {
        this.frameStore.addValues((Frame)subject, slot, null, false, (Collection)Collections.singleton(object));
    }

    public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean contains(RDFResource subject, RDFProperty predicate, Object object) {
        Collection values = this.getValues(subject, predicate);
        if (values != null) {
            if (object instanceof RDFSLiteral) {
                values = subject.getOWLModel().asRDFSLiterals(values);
            }
            return values.contains(object);
        }
        return false;
    }

    public String getDefaultNamespace() {
        return this.getNamespaceForPrefix("");
    }

    public String getName() {
        return this.frameStore.getName();
    }

    public RDFResource getHomeResource(String name) {
        Set values = this.frameStore.getFrames(this.nameSlot, null, false, (Object)name);
        if (values.isEmpty()) {
            return null;
        }
        return (RDFResource)values.iterator().next();
    }

    public String getNamespaceForPrefix(String prefix) {
        RDFResource ontology = TripleStoreUtil.getFirstOntology(this.owlModel, this);
        if (ontology != null) {
            prefix = String.valueOf(prefix) + ":";
            RDFProperty prefixesSlot = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
            List values = this.getNarrowFrameStore().getValues((Frame)ontology, (Slot)prefixesSlot, null, false);
            for (String value : values) {
                if (!value.startsWith(prefix)) continue;
                return value.substring(prefix.length());
            }
        }
        return null;
    }

    public NarrowFrameStore getNarrowFrameStore() {
        return this.frameStore;
    }

    public Collection getSlotValues(Instance instance, Slot slot) {
        return this.tripleStoreModel.getSlotValues(instance, slot);
    }

    protected Collection getValues(Instance instance, Slot slot) {
        return this.frameStore.getValues((Frame)instance, slot, null, false);
    }

    public String getPrefix(String namespace) {
        RDFResource ontology = TripleStoreUtil.getFirstOntology(this.owlModel, this);
        if (ontology != null) {
            String suffix = ":" + namespace;
            RDFProperty prefixesSlot = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
            List values = this.getNarrowFrameStore().getValues((Frame)ontology, (Slot)prefixesSlot, null, false);
            for (String value : values) {
                if (!value.endsWith(suffix)) continue;
                return value.substring(0, value.length() - suffix.length());
            }
        }
        return null;
    }

    public Collection getPrefixes() {
        ArrayList<String> results = new ArrayList<String>();
        RDFResource ontology = TripleStoreUtil.getFirstOntology(this.owlModel, this);
        if (ontology != null) {
            RDFProperty prefixesSlot = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
            List values = this.getNarrowFrameStore().getValues((Frame)ontology, (Slot)prefixesSlot, null, false);
            for (String value : values) {
                int index = value.indexOf(58);
                results.add(value.substring(0, index));
            }
        }
        return results;
    }

    protected Collection getReferences(Object search) {
        return this.frameStore.getReferences(search);
    }

    private void initAACHandler(String propertyName, String clsName, Class clazz) {
        Cls cls = this.owlModel.getCls(clsName);
        this.initHandler(propertyName, new AddAnonymousClassPropertyPropertyHandler(this, cls, clazz, this.tripleStoreModel));
    }

    private void initHandler(String propertyName, AddPropertyValueHandler handler) {
        this.addPropertyValueHandlers.put(this.owlModel.getRDFProperty(propertyName), handler);
    }

    public Iterator listHomeResources() {
        Set frames = this.frameStore.getFramesWithAnyValue(this.nameSlot, null, false);
        Collection results = AbstractOWLModel.getRDFResources(this.owlModel, frames);
        return results.iterator();
    }

    public Iterator listObjects(RDFResource subject, RDFProperty property) {
        return this.getValues(subject, property).iterator();
    }

    public Iterator listSubjects(RDFProperty property) {
        Set frames = this.frameStore.getFramesWithAnyValue((Slot)property, null, false);
        return frames.iterator();
    }

    public Iterator listSubjects(RDFProperty predicate, Object object) {
        if (object instanceof DefaultRDFSLiteral && (object = DefaultRDFSLiteral.getPlainValueIfPossible(object)) instanceof DefaultRDFSLiteral) {
            object = ((DefaultRDFSLiteral)object).getRawValue();
        }
        return this.frameStore.getFrames((Slot)predicate, null, false, object).iterator();
    }

    public Iterator listTriplesWithObject(RDFObject object) {
        Object search = object;
        if (object instanceof DefaultRDFSLiteral) {
            Object plain = ((DefaultRDFSLiteral)object).getPlainValue();
            search = plain == null ? ((DefaultRDFSLiteral)object).getRawValue() : plain;
        }
        ArrayList<DefaultTriple> triples = new ArrayList<DefaultTriple>();
        Collection refs = this.getReferences(search);
        for (Reference reference : refs) {
            if (!(reference.getFrame() instanceof RDFResource) || !(reference.getSlot() instanceof RDFProperty) || Model.SlotID.DIRECT_INSTANCES.equals((Object)reference.getSlot().getFrameID())) continue;
            DefaultTriple triple = new DefaultTriple((RDFResource)reference.getFrame(), (RDFProperty)reference.getSlot(), object);
            triples.add(triple);
        }
        return triples.iterator();
    }

    public Iterator listTriplesWithSubject(RDFResource subject) {
        ArrayList<DefaultTriple> triples = new ArrayList<DefaultTriple>();
        Iterator properties = subject.getOWLModel().listRDFProperties();
        while (properties.hasNext()) {
            RDFProperty property = (RDFProperty)properties.next();
            Iterator it = this.listObjects(subject, property);
            while (it.hasNext()) {
                Object object = it.next();
                DefaultTriple triple = new DefaultTriple(subject, property, object);
                triples.add(triple);
            }
        }
        return triples.iterator();
    }

    public void remove(Triple triple) {
        this.remove(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public void remove(RDFResource subject, RDFProperty predicate, Object object) {
        if (predicate.equals(subject.getOWLModel().getRDFTypeProperty())) {
            this.removeDirectType(subject, object);
        }
        this.removeValue(subject, predicate, object);
    }

    public void setName(String value) {
        this.getNarrowFrameStore().setName(value);
    }

    private void removeDirectType(RDFResource subject, Object object) {
        this.removeValue((Instance)object, this.directInstancesSlot, subject);
        this.removeValue(subject, this.directTypesSlot, object);
    }

    public void removePrefix(String prefix) {
        String namespace = this.getNamespaceForPrefix(prefix);
        if (namespace != null) {
            RDFResource ontology = TripleStoreUtil.getFirstOntology(this.owlModel, this);
            RDFProperty prefixesSlot = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
            String value = String.valueOf(prefix) + ":" + namespace;
            this.getNarrowFrameStore().removeValue((Frame)ontology, (Slot)prefixesSlot, null, false, (Object)value);
        }
    }

    protected void removeValue(Instance subject, Slot slot, Object value) {
        this.frameStore.removeValue((Frame)subject, slot, null, false, value);
    }

    public void setDefaultNamespace(String value) {
        this.setPrefix(value, "");
    }

    public void setDefaultNamespace(URI uri) {
        this.setDefaultNamespace(uri.toString());
    }

    public void setPrefix(String namespace, String prefix) {
        this.removePrefix(prefix);
        RDFResource ontology = TripleStoreUtil.getFirstOntology(this.owlModel, this);
        RDFProperty prefixesSlot = this.owlModel.getRDFProperty(":OWL-ONTOLOGY-PREFIXES");
        String value = String.valueOf(prefix) + ":" + namespace;
        this.getNarrowFrameStore().addValues((Frame)ontology, (Slot)prefixesSlot, null, false, (Collection)Collections.singleton(value));
    }

    public void setPrefix(URI namespace, String prefix) {
        this.setPrefix(namespace.toString(), prefix);
    }

    public void setRDFResourceName(RDFResource resource, String name) {
        NarrowFrameStore nfs;
        List values;
        Iterator it;
        TripleStore home = this.tripleStoreModel.getHomeTripleStore(resource);
        if (home != null && (it = (values = (nfs = home.getNarrowFrameStore()).getValues((Frame)resource, this.nameSlot, null, false)).iterator()).hasNext()) {
            String oldName = (String)it.next();
            nfs.removeValue((Frame)resource, this.nameSlot, null, false, (Object)oldName);
        }
        this.addValueFast(resource, this.nameSlot, name);
    }

    public void sortPropertyValues(RDFResource resource, RDFProperty property, Comparator comparator) {
        TripleStoreUtil.sortSlotValues(this.getNarrowFrameStore(), resource, property, comparator);
    }

    public String toString() {
        return "TripleStore(" + this.getName() + ")";
    }

    public void dump() {
        System.out.println("Triples in " + this.getName());
        Iterator it = this.listTriples();
        while (it.hasNext()) {
            System.out.println(" - " + it.next());
        }
    }
}

