/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl.tests;

import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.tests.AbstractTripleStoreTestCase;

public class CreateRDFPropertyTestCase
extends AbstractTripleStoreTestCase {
    public void testCreateRDFProperty() {
        RDFResource c = this.createRDFResource("test");
        this.ts.add(c, this.rdfTypeProperty, this.owlModel.getRDFPropertyClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        CreateRDFPropertyTestCase.assertTrue((boolean)(this.owlModel.getRDFProperty(c.getName()) instanceof RDFProperty));
        CreateRDFPropertyTestCase.assertFalse((boolean)(this.owlModel.getRDFProperty(c.getName()) instanceof OWLProperty));
    }

    public void testCreateFunctionalRDFProperty() {
        RDFResource c = this.createRDFResource("property");
        this.ts.add(c, this.rdfTypeProperty, this.owlModel.getOWLFunctionalPropertyClass());
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        RDFProperty property = this.owlModel.getRDFProperty(c.getName());
        CreateRDFPropertyTestCase.assertTrue((boolean)property.isFunctional());
    }

    public void testCreateSymmetricProperty() {
        RDFResource c = this.createRDFResource("test");
        this.ts.add(c, this.rdfTypeProperty, this.owlModel.getRDFSNamedClass("owl:SymmetricProperty"));
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        RDFProperty property = this.owlModel.getRDFProperty(c.getName());
        CreateRDFPropertyTestCase.assertTrue((boolean)(property instanceof OWLObjectProperty));
        CreateRDFPropertyTestCase.assertTrue((boolean)((OWLObjectProperty)property).isSymmetric());
    }

    public void testCreateTransitiveProperty() {
        RDFResource c = this.createRDFResource("test");
        this.ts.add(c, this.rdfTypeProperty, this.owlModel.getRDFSNamedClass("owl:TransitiveProperty"));
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        RDFProperty property = this.owlModel.getRDFProperty(c.getName());
        CreateRDFPropertyTestCase.assertTrue((boolean)(property instanceof OWLObjectProperty));
        CreateRDFPropertyTestCase.assertTrue((boolean)((OWLObjectProperty)property).isTransitive());
    }

    public void testCreateSubProperty() {
        RDFProperty superproperty = this.owlModel.createRDFProperty("super");
        RDFProperty subproperty = this.owlModel.createRDFProperty("sub");
        this.ts.add(subproperty, this.owlModel.getRDFProperty("rdfs:subPropertyOf"), superproperty);
        this.owlModel.getTripleStoreModel().endTripleStoreChanges();
        CreateRDFPropertyTestCase.assertSize(1, subproperty.getSuperproperties(false));
        CreateRDFPropertyTestCase.assertContains((Object)superproperty, subproperty.getSuperproperties(false));
        CreateRDFPropertyTestCase.assertSize(1, superproperty.getSubproperties(false));
        CreateRDFPropertyTestCase.assertContains((Object)subproperty, superproperty.getSubproperties(false));
    }
}

