/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util.tests;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLQuantifierRestriction;
import edu.stanford.smi.protegex.owl.model.OWLRestriction;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.util.CloneFactory;
import edu.stanford.smi.protegex.owl.model.util.ResourceCopier;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;

public class CloneFactoryTestCase
extends AbstractJenaTestCase {
    public void testCloneOWLNamedClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        a.addSuperclass(b);
        OWLNamedClass clone = CloneFactory.cloneOWLNamedClass(a);
        CloneFactoryTestCase.assertNotNull((Object)clone);
        CloneFactoryTestCase.assertTrue((boolean)clone.getSuperclasses(false).contains(b));
    }

    public void testCloneOWLNamedClassWithRestrictionWithNamedClassFiller() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        OWLObjectProperty p = this.owlModel.createOWLObjectProperty("p");
        OWLSomeValuesFrom r = this.owlModel.createOWLSomeValuesFrom((RDFProperty)p, b);
        a.addSuperclass(r);
        OWLNamedClass clone = CloneFactory.cloneOWLNamedClass(a);
        CloneFactoryTestCase.assertNotNull((Object)clone);
        OWLQuantifierRestriction rclone = null;
        Iterator clonesupers = clone.getSuperclasses(false).iterator();
        while (clonesupers.hasNext() && rclone == null) {
            RDFSClass s = (RDFSClass)clonesupers.next();
            if (!(s instanceof OWLSomeValuesFrom)) continue;
            rclone = (OWLSomeValuesFrom)s;
        }
        CloneFactoryTestCase.assertNotNull(rclone);
        CloneFactoryTestCase.assertTrue((rclone != r ? 1 : 0) != 0);
        CloneFactoryTestCase.assertSame((Object)rclone.getFiller(), (Object)b);
        CloneFactoryTestCase.assertSame((Object)rclone.getOnProperty(), (Object)p);
    }

    public void testCloneOWLNamedClassWithRestrictionWithUnionClassFiller() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass c = this.owlModel.createOWLNamedClass("C");
        OWLUnionClass u = this.owlModel.createOWLUnionClass();
        u.addOperand(b);
        u.addOperand(c);
        OWLObjectProperty p = this.owlModel.createOWLObjectProperty("p");
        OWLAllValuesFrom r = this.owlModel.createOWLAllValuesFrom((RDFProperty)p, u);
        a.addSuperclass(r);
        OWLNamedClass clone = CloneFactory.cloneOWLNamedClass(a);
        CloneFactoryTestCase.assertNotNull((Object)clone);
        OWLRestriction rclone = null;
        Iterator clonesupers = clone.getSuperclasses(false).iterator();
        while (clonesupers.hasNext() && rclone == null) {
            RDFSClass s = (RDFSClass)clonesupers.next();
            if (!(s instanceof OWLAllValuesFrom)) continue;
            rclone = (OWLAllValuesFrom)s;
        }
        CloneFactoryTestCase.assertNotNull(rclone);
        CloneFactoryTestCase.assertNotSame(rclone, (Object)r);
        CloneFactoryTestCase.assertSame((Object)rclone.getOnProperty(), (Object)p);
        CloneFactoryTestCase.assertNotSame((Object)rclone.getFiller(), (Object)u);
        CloneFactoryTestCase.assertTrue((boolean)((OWLUnionClass)rclone.getFiller()).getOperands().contains(b));
        CloneFactoryTestCase.assertTrue((boolean)((OWLUnionClass)rclone.getFiller()).getOperands().contains(c));
    }

    public void testCopyOWLEnumeratedClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        ArrayList<OWLIndividual> aInds = new ArrayList<OWLIndividual>();
        aInds.add(a.createOWLIndividual("a1"));
        aInds.add(a.createOWLIndividual("a2"));
        aInds.add(a.createOWLIndividual("a3"));
        OWLEnumeratedClass e = this.owlModel.createOWLEnumeratedClass(aInds);
        ResourceCopier cfactory = new ResourceCopier();
        e.accept(cfactory);
        OWLEnumeratedClass clone = (OWLEnumeratedClass)cfactory.getCopy();
        CloneFactoryTestCase.assertNotNull((Object)clone);
        for (OWLIndividual ind : clone.getOneOf()) {
            CloneFactoryTestCase.assertTrue((boolean)aInds.contains(ind));
            aInds.remove(ind);
        }
    }

    public void testCopyComplementClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLComplementClass not = this.owlModel.createOWLComplementClass(a);
        ResourceCopier copier = new ResourceCopier();
        not.accept(copier);
        OWLComplementClass clone = (OWLComplementClass)copier.getCopy();
        CloneFactoryTestCase.assertNotNull((Object)clone);
        CloneFactoryTestCase.assertSame((Object)clone.getComplement(), (Object)a);
    }

    public void testCloneDefinedClass() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        OWLObjectProperty p = this.owlModel.createOWLObjectProperty("p");
        OWLSomeValuesFrom r = this.owlModel.createOWLSomeValuesFrom((RDFProperty)p, b);
        a.addEquivalentClass(r);
        OWLNamedClass clone = CloneFactory.cloneOWLNamedClass(a);
        CloneFactoryTestCase.assertNotNull((Object)clone);
        CloneFactoryTestCase.assertTrue((boolean)clone.isDefinedClass());
    }

    public void testCopyRDFList() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        ArrayList<OWLNamedClass> values = new ArrayList<OWLNamedClass>();
        values.add(a);
        values.add(b);
        RDFList list = this.owlModel.createRDFList(values.iterator());
        ResourceCopier copier = new ResourceCopier();
        list.accept(copier);
        RDFList clone = (RDFList)copier.getCopy();
        CloneFactoryTestCase.assertNotNull((Object)clone);
        CloneFactoryTestCase.assertSame((Object)clone.getFirst(), (Object)a);
        CloneFactoryTestCase.assertSame((Object)clone.getRest().getFirst(), (Object)b);
    }

    public void testCopyIntersection() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        ArrayList<OWLNamedClass> intClasses = new ArrayList<OWLNamedClass>();
        intClasses.add(a);
        intClasses.add(b);
        OWLIntersectionClass inter = this.owlModel.createOWLIntersectionClass(intClasses);
        ResourceCopier copier = new ResourceCopier();
        inter.accept(copier);
        OWLIntersectionClass clone = (OWLIntersectionClass)copier.getCopy();
        CloneFactoryTestCase.assertNotNull((Object)clone);
        Collection operands = clone.getOperands();
        CloneFactoryTestCase.assertTrue((boolean)operands.contains(a));
        CloneFactoryTestCase.assertTrue((boolean)operands.contains(b));
    }

    public void testCloneDefinedClassUsingIntersection() {
        OWLNamedClass a = this.owlModel.createOWLNamedClass("A");
        OWLNamedClass b = this.owlModel.createOWLNamedClass("B");
        OWLNamedClass c = this.owlModel.createOWLNamedClass("C");
        ArrayList<OWLNamedClass> intClasses = new ArrayList<OWLNamedClass>();
        intClasses.add(a);
        intClasses.add(b);
        OWLIntersectionClass inter = this.owlModel.createOWLIntersectionClass(intClasses);
        c.addEquivalentClass(inter);
        OWLNamedClass clone = CloneFactory.cloneOWLNamedClass(c);
        CloneFactoryTestCase.assertNotNull((Object)clone);
        CloneFactoryTestCase.assertTrue((boolean)clone.isDefinedClass());
    }

    public void testCloneCheeseyPizza() {
        OWLNamedClass pizza = this.owlModel.createOWLNamedClass("Pizza");
        OWLNamedClass cheeseyPizza = this.owlModel.createOWLNamedClass("CheeseyPizza");
        OWLNamedClass cheeseTopping = this.owlModel.createOWLNamedClass("CheeseTopping");
        OWLObjectProperty hasTopping = this.owlModel.createOWLObjectProperty("hasTopping");
        OWLSomeValuesFrom restr = this.owlModel.createOWLSomeValuesFrom((RDFProperty)hasTopping, cheeseTopping);
        ArrayList<OWLClass> intClasses = new ArrayList<OWLClass>();
        intClasses.add(pizza);
        intClasses.add(restr);
        OWLIntersectionClass inter = this.owlModel.createOWLIntersectionClass(intClasses);
        cheeseyPizza.addEquivalentClass(inter);
        OWLNamedClass clone = CloneFactory.cloneOWLNamedClass(cheeseyPizza);
        CloneFactoryTestCase.assertNotNull((Object)clone);
        CloneFactoryTestCase.assertTrue((boolean)clone.isDefinedClass());
    }

    public void testSavingAfterCloning() {
        this.testCloneCheeseyPizza();
        try {
            this.owlModel.save(new File("out.owl").toURI());
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
            CloneFactoryTestCase.fail();
        }
    }
}

