/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.repository.util;

import edu.stanford.smi.protegex.owl.repository.util.XMLBaseExtractor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;

public class OntologyNameExtractor {
    private InputStream is;
    private URI uri;
    private URL url;
    private boolean rdfRootPresent;

    public OntologyNameExtractor(InputStream is, URL documentURL) {
        this.is = is;
        this.url = documentURL;
        this.uri = null;
        this.rdfRootPresent = false;
        this.init();
    }

    private void init() {
        if (this.is != null) {
            try {
                XMLBaseExtractor extractor = new XMLBaseExtractor(this.is);
                this.uri = extractor.getXMLBase();
                String rootElementName = extractor.getRootElementName();
                if (rootElementName != null) {
                    this.rdfRootPresent = rootElementName.toLowerCase().equals("rdf:rdf");
                } else {
                    this.uri = null;
                }
            }
            finally {
                this.is = null;
            }
        }
    }

    public boolean isRDFRootElementPresent() {
        return this.rdfRootPresent;
    }

    public URI getOntologyName() throws IOException {
        return this.uri;
    }
}

