/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.bridge;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.swrl.bridge.AllDifferentRestrictionInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.Argument;
import edu.stanford.smi.protegex.owl.swrl.bridge.AtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.BuiltInAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.ClassInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.DataRangeAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.DatavaluedPropertyAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.DifferentFromRestrictionInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.DifferentIndividualsAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.IndividualPropertyAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.Info;
import edu.stanford.smi.protegex.owl.swrl.bridge.LiteralInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.PropertyInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.RestrictionInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.RuleInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.SameAsRestrictionInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.SameIndividualAtomInfo;
import edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInMethods;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.BuiltInMethodRuntimeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.IncompatibleBuiltInClassException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.IncompatibleBuiltInMethodException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InconsistentKnowledgeBaseException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidBuiltInNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidClassNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidPropertyNameException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.InvalidSWRLAtomException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.SWRLRuleEngineBridgeException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.UnresolvedBuiltInClassException;
import edu.stanford.smi.protegex.owl.swrl.bridge.exceptions.UnresolvedBuiltInMethodException;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLClassAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDataRangeAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDatavaluedPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLDifferentIndividualsAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLFactory;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividualPropertyAtom;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLSameIndividualAtom;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public abstract class SWRLRuleEngineBridge {
    protected OWLModel owlModel;
    private List importedSWRLRules;
    private List referencedClassNames;
    private List referencedPropertyNames;
    private List referencedIndividualNames;
    private HashMap importedClasses;
    private HashMap importedIndividuals;
    private List importedProperties;
    private List importedPropertyNames;
    private List importedRestrictions;
    private List exportedClassNames;
    private List exportedIndividualNames;
    private List assertedIndividuals;
    private List assertedProperties;
    private HashMap builtInMethodsClassInstances;

    protected abstract void defineRule(RuleInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void defineClass(ClassInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void defineProperty(PropertyInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void defineIndividual(IndividualInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void defineRestriction(RestrictionInfo var1) throws SWRLRuleEngineBridgeException;

    protected abstract void initializeRuleEngine() throws SWRLRuleEngineBridgeException;

    public abstract void runRuleEngine() throws SWRLRuleEngineBridgeException;

    protected SWRLRuleEngineBridge(OWLModel owlModel) throws SWRLRuleEngineBridgeException {
        this.owlModel = owlModel;
        this.importedSWRLRules = new ArrayList();
        this.referencedClassNames = new ArrayList();
        this.referencedIndividualNames = new ArrayList();
        this.referencedPropertyNames = new ArrayList();
        this.importedClasses = new HashMap();
        this.importedIndividuals = new HashMap();
        this.importedProperties = new ArrayList();
        this.importedPropertyNames = new ArrayList();
        this.importedRestrictions = new ArrayList();
        this.exportedClassNames = new ArrayList();
        this.exportedIndividualNames = new ArrayList();
        this.assertedIndividuals = new ArrayList();
        this.assertedProperties = new ArrayList();
        this.builtInMethodsClassInstances = new HashMap();
    }

    public void importSWRLRulesAndOWLKnowledge() throws SWRLRuleEngineBridgeException {
        this.resetRuleEngine();
        if (!this.owlModel.getInconsistentClasses().isEmpty()) {
            throw new InconsistentKnowledgeBaseException("Cannot import rules from an inconsistent knowledge base");
        }
        this.importSWRLRules();
        this.importOWLClasses(this.referencedClassNames);
        this.importOWLProperties(this.referencedPropertyNames);
        this.importOWLIndividuals(this.referencedIndividualNames);
        this.importAllOWLIndividualsOfClasses(this.referencedClassNames);
        this.importOWLRestrictions();
    }

    public void exportSWRLRulesAndOWLKnowledge() throws SWRLRuleEngineBridgeException {
        this.exportOWLClasses();
        this.exportOWLIndividuals();
        this.exportOWLProperties();
        this.exportOWLRestrictions();
        this.exportSWRLRules();
    }

    public void writeAssertedIndividualsAndProperties2OWL() throws SWRLRuleEngineBridgeException {
        this.writeAssertedIndividuals2OWL();
        this.writeAssertedProperties2OWL();
    }

    public void resetBridge() throws SWRLRuleEngineBridgeException {
        this.importedSWRLRules.clear();
        this.referencedClassNames.clear();
        this.referencedPropertyNames.clear();
        this.referencedIndividualNames.clear();
        this.importedClasses.clear();
        this.importedProperties.clear();
        this.importedPropertyNames.clear();
        this.importedIndividuals.clear();
        this.importedRestrictions.clear();
        this.clearExportedAndAssertedKnowledge();
        this.resetRuleEngine();
    }

    public void resetRuleEngine() throws SWRLRuleEngineBridgeException {
        this.initializeRuleEngine();
        this.clearExportedAndAssertedKnowledge();
    }

    public OWLModel getOWLModel() {
        return this.owlModel;
    }

    public int getNumberOfImportedSWRLRules() {
        return this.importedSWRLRules.size();
    }

    public int getNumberOfImportedClasses() {
        return this.importedClasses.size();
    }

    public int getNumberOfImportedIndividuals() {
        return this.importedIndividuals.size();
    }

    public int getNumberOfImportedProperties() {
        return this.importedProperties.size();
    }

    public int getNumberOfImportedRestrictions() {
        return this.importedRestrictions.size();
    }

    public int getNumberOfAssertedIndividuals() {
        return this.assertedIndividuals.size();
    }

    public int getNumberOfAssertedProperties() {
        return this.assertedProperties.size();
    }

    protected List getImportedSWRLRules() {
        return this.importedSWRLRules;
    }

    protected List getImportedClasses() {
        return new ArrayList(this.importedClasses.values());
    }

    protected List getImportedIndividuals() {
        return new ArrayList(this.importedIndividuals.values());
    }

    protected List getImportedProperties() {
        return this.importedProperties;
    }

    protected List getImportedRestrictions() {
        return this.importedRestrictions;
    }

    protected List getAssertedIndividuals() {
        return this.assertedIndividuals;
    }

    protected List getAssertedProperties() {
        return this.assertedProperties;
    }

    public void assertProperty(String propertyName, String subjectName, String predicateValue) throws SWRLRuleEngineBridgeException {
        IndividualInfo subject = new IndividualInfo(subjectName);
        Info predicate = this.isObjectProperty(propertyName) ? new IndividualInfo(predicateValue) : new LiteralInfo(predicateValue);
        PropertyInfo propertyInfo = new PropertyInfo(propertyName, subject, (Argument)((Object)predicate));
        if (!this.assertedProperties.contains(propertyInfo)) {
            this.assertedProperties.add(propertyInfo);
        }
    }

    public void assertIndividual(String individualName, String className) throws SWRLRuleEngineBridgeException {
        IndividualInfo individualInfo = new IndividualInfo(individualName, className);
        if (!this.assertedIndividuals.contains(individualInfo)) {
            this.assertedIndividuals.add(individualInfo);
        }
    }

    public boolean invokeSWRLBuiltIn(String builtInName, List arguments) throws BuiltInException {
        String className;
        SWRLBuiltInMethods swrlBuiltInMethods = null;
        Object swrlBuiltInMethodsClass = null;
        String namespaceName = "";
        String builtInMethodName = "";
        Boolean result = false;
        if (!this.isBuiltIn(builtInName)) {
            throw new InvalidBuiltInNameException(builtInName);
        }
        int colonIndex = builtInName.indexOf(58);
        if (colonIndex != -1) {
            namespaceName = builtInName.substring(0, colonIndex);
            builtInMethodName = builtInName.substring(colonIndex + 1, builtInName.length());
            className = "edu.stanford.smi.protegex.owl.swrl.bridge.builtins." + namespaceName + ".SWRLBuiltInMethodsImpl";
        } else {
            namespaceName = "";
            builtInMethodName = builtInName;
            className = "edu.stanford.smi.protegex.owl.swrl.bridge.builtins.SWRLBuiltInMethodsImpl";
        }
        if (this.builtInMethodsClassInstances.containsKey(namespaceName)) {
            swrlBuiltInMethods = (SWRLBuiltInMethods)this.builtInMethodsClassInstances.get(namespaceName);
        } else {
            swrlBuiltInMethods = this.loadSWRLBuiltInMethodsImpl(namespaceName, className);
            this.builtInMethodsClassInstances.put(namespaceName, swrlBuiltInMethods);
        }
        Method method = this.resolveBuiltInMethod(namespaceName, builtInMethodName, swrlBuiltInMethods);
        this.checkBuiltInMethod(namespaceName, builtInMethodName, method);
        try {
            result = (Boolean)method.invoke((Object)swrlBuiltInMethods, arguments);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof BuiltInException) {
                throw (BuiltInException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw new BuiltInMethodRuntimeException(namespaceName, builtInMethodName, targetException.getMessage(), targetException);
            }
        }
        catch (Exception e) {
            throw new BuiltInException("Internal bridge exception when invoking built-in method '" + builtInMethodName + "' in namespace '" + namespaceName + "'. Exception: " + e.toString(), e);
        }
        return result;
    }

    private Method resolveBuiltInMethod(String namespaceName, String builtInMethodName, SWRLBuiltInMethods swrlBuiltInMethods) throws UnresolvedBuiltInMethodException {
        Method method;
        try {
            method = swrlBuiltInMethods.getClass().getMethod(builtInMethodName, List.class);
        }
        catch (Exception e) {
            throw new UnresolvedBuiltInMethodException(namespaceName, builtInMethodName, e.getMessage());
        }
        return method;
    }

    private SWRLBuiltInMethods loadSWRLBuiltInMethodsImpl(String namespaceName, String className) throws UnresolvedBuiltInClassException, IncompatibleBuiltInClassException {
        SWRLBuiltInMethods swrlBuiltInMethods;
        Class<?> swrlBuiltInMethodsClass;
        try {
            swrlBuiltInMethodsClass = Class.forName(className);
        }
        catch (Exception e) {
            throw new UnresolvedBuiltInClassException(namespaceName, e.getMessage());
        }
        this.checkBuiltInClass(namespaceName, swrlBuiltInMethodsClass);
        try {
            swrlBuiltInMethods = (SWRLBuiltInMethods)swrlBuiltInMethodsClass.newInstance();
        }
        catch (Exception e) {
            throw new UnresolvedBuiltInClassException(namespaceName, e.getMessage());
        }
        return swrlBuiltInMethods;
    }

    private void importSWRLRules() throws SWRLRuleEngineBridgeException {
        SWRLFactory factory = new SWRLFactory(this.owlModel);
        Collection rules = factory.getImps();
        if (rules == null) {
            return;
        }
        for (SWRLImp rule : rules) {
            this.importSWRLRule(rule);
        }
    }

    private void importSWRLRule(SWRLImp rule) throws SWRLRuleEngineBridgeException {
        ArrayList bodyAtoms = new ArrayList();
        ArrayList headAtoms = new ArrayList();
        RuleInfo ruleInfo = new RuleInfo(rule.getName());
        for (SWRLAtom swrlAtom : rule.getBody().getValues()) {
            ruleInfo.addBodyAtom(this.processSWRLAtom(swrlAtom, false));
        }
        for (SWRLAtom swrlAtom : rule.getHead().getValues()) {
            ruleInfo.addHeadAtom(this.processSWRLAtom(swrlAtom, true));
        }
        this.preProcessAtoms(ruleInfo);
        this.importedSWRLRules.add(ruleInfo);
    }

    private AtomInfo processSWRLAtom(SWRLAtom swrlAtom, boolean isConsequent) throws SWRLRuleEngineBridgeException {
        AtomInfo atomInfo;
        if (swrlAtom instanceof SWRLClassAtom) {
            atomInfo = new ClassAtomInfo((SWRLClassAtom)swrlAtom);
            if (!this.referencedClassNames.contains(atomInfo.getName())) {
                this.referencedClassNames.add(atomInfo.getName());
            }
        } else if (swrlAtom instanceof SWRLDatavaluedPropertyAtom) {
            atomInfo = new DatavaluedPropertyAtomInfo(this.owlModel, (SWRLDatavaluedPropertyAtom)swrlAtom);
            if (!this.referencedPropertyNames.contains(atomInfo.getName())) {
                this.referencedPropertyNames.add(atomInfo.getName());
            }
        } else if (swrlAtom instanceof SWRLIndividualPropertyAtom) {
            atomInfo = new IndividualPropertyAtomInfo((SWRLIndividualPropertyAtom)swrlAtom);
            if (!this.referencedPropertyNames.contains(atomInfo.getName())) {
                this.referencedPropertyNames.add(atomInfo.getName());
            }
        } else if (swrlAtom instanceof SWRLSameIndividualAtom) {
            atomInfo = new SameIndividualAtomInfo((SWRLSameIndividualAtom)swrlAtom);
        } else if (swrlAtom instanceof SWRLDifferentIndividualsAtom) {
            atomInfo = new DifferentIndividualsAtomInfo((SWRLDifferentIndividualsAtom)swrlAtom);
        } else if (swrlAtom instanceof SWRLBuiltinAtom) {
            if (isConsequent) {
                throw new SWRLRuleEngineBridgeException("Attempt to use built-in ('" + swrlAtom.getBrowserText() + "') in rule consequent.");
            }
            atomInfo = new BuiltInAtomInfo(this.owlModel, (SWRLBuiltinAtom)swrlAtom);
        } else if (swrlAtom instanceof SWRLDataRangeAtom) {
            atomInfo = new DataRangeAtomInfo((SWRLDataRangeAtom)swrlAtom);
        } else {
            throw new InvalidSWRLAtomException(swrlAtom.getBrowserText());
        }
        if (atomInfo.hasReferencedIndividuals()) {
            this.referencedIndividualNames.addAll(atomInfo.getReferencedIndividualNames());
        }
        return atomInfo;
    }

    private void importOWLClass(String className) throws SWRLRuleEngineBridgeException {
        if (!this.importedClasses.containsKey(className)) {
            ClassInfo classInfo = new ClassInfo(this.owlModel, className);
            this.importedClasses.put(className, classInfo);
            this.importOWLClasses(classInfo.getDirectSuperClassNames());
            this.importOWLClasses(classInfo.getDirectSubClassNames());
        }
    }

    private void importOWLClasses(Collection classNames) throws SWRLRuleEngineBridgeException {
        for (String className : classNames) {
            this.importOWLClass(className);
        }
    }

    private void importAllOWLIndividualsOfClasses(Collection classNames) throws SWRLRuleEngineBridgeException {
        for (String className : classNames) {
            this.importAllOWLIndividualsOfClass(className);
        }
    }

    private void importAllOWLIndividualsOfClass(String className) throws SWRLRuleEngineBridgeException {
        RDFSNamedClass rdfsClass = this.owlModel.getRDFSNamedClass(className);
        if (rdfsClass == null) {
            throw new InvalidClassNameException(className);
        }
        for (Object o : rdfsClass.getInstances(true)) {
            if (!(o instanceof OWLIndividual)) continue;
            OWLIndividual individual = (OWLIndividual)o;
            String individualName = individual.getName();
            IndividualInfo individualInfo = new IndividualInfo(this.owlModel, individualName);
            this.importedIndividuals.put(individualName, individualInfo);
        }
    }

    private void importOWLProperties(Collection propertyNames) throws SWRLRuleEngineBridgeException {
        for (String propertyName : propertyNames) {
            this.importOWLProperty(propertyName);
        }
    }

    private void importOWLProperty(String propertyName) throws SWRLRuleEngineBridgeException {
        if (!this.importedPropertyNames.contains(propertyName)) {
            List propertyInfoList = PropertyInfo.buildPropertyInfoList(this.owlModel, propertyName);
            this.importedProperties.addAll(propertyInfoList);
            this.importedPropertyNames.add(propertyName);
            if (!propertyInfoList.isEmpty()) {
                PropertyInfo propertyInfo = (PropertyInfo)propertyInfoList.get(0);
                this.importOWLClasses(propertyInfo.getDomainClassNames());
                this.importOWLClasses(propertyInfo.getRangeClassNames());
            }
        }
    }

    private void importOWLIndividuals(Collection individualNames) throws SWRLRuleEngineBridgeException {
        for (String individualName : individualNames) {
            this.importOWLIndividual(individualName);
        }
    }

    private void importOWLIndividual(String individualName) throws SWRLRuleEngineBridgeException {
        if (!this.importedIndividuals.containsKey(individualName)) {
            return;
        }
        IndividualInfo individualInfo = new IndividualInfo(this.owlModel, individualName);
        this.importedIndividuals.put(individualName, individualInfo);
        this.importOWLClasses(individualInfo.getClassNames());
    }

    private void importOWLRestrictions() throws SWRLRuleEngineBridgeException {
        this.importOWLSameAsRestrictions();
        this.importOWLDifferentFromRestrictions();
        this.importOWLAllDifferents();
    }

    private void importOWLSameAsRestrictions() throws SWRLRuleEngineBridgeException {
        RDFProperty sameAsProperty = this.owlModel.getOWLSameAsProperty();
        OWLNamedClass owlThingCls = this.owlModel.getOWLNamedClass("owl:Thing");
        for (Object object1 : owlThingCls.getInstances(true)) {
            OWLIndividual individual1;
            if (!(object1 instanceof OWLIndividual) || !(individual1 = (OWLIndividual)object1).hasPropertyValue(sameAsProperty)) continue;
            Collection individuals = individual1.getPropertyValues(sameAsProperty);
            for (Object object2 : individuals) {
                if (!(object2 instanceof OWLIndividual)) continue;
                OWLIndividual individual2 = (OWLIndividual)object2;
                this.importedRestrictions.add(new SameAsRestrictionInfo(individual1.getName(), individual2.getName()));
            }
        }
    }

    private void importOWLDifferentFromRestrictions() throws SWRLRuleEngineBridgeException {
        RDFProperty differentFromProperty = this.owlModel.getOWLDifferentFromProperty();
        OWLNamedClass owlThingCls = this.owlModel.getOWLNamedClass("owl:Thing");
        for (Object object1 : owlThingCls.getInstances(true)) {
            OWLIndividual individual1;
            if (!(object1 instanceof OWLIndividual) || !(individual1 = (OWLIndividual)object1).hasPropertyValue(differentFromProperty)) continue;
            Collection individuals = individual1.getPropertyValues(differentFromProperty);
            for (Object object2 : individuals) {
                if (!(object2 instanceof OWLIndividual)) continue;
                OWLIndividual individual2 = (OWLIndividual)object2;
                this.importedRestrictions.add(new DifferentFromRestrictionInfo(individual1.getName(), individual2.getName()));
            }
        }
    }

    private void importOWLAllDifferents() throws SWRLRuleEngineBridgeException {
        Collection allDifferents = this.owlModel.getOWLAllDifferents();
        if (!allDifferents.isEmpty()) {
            for (OWLAllDifferent owlAllDifferent : allDifferents) {
                AllDifferentRestrictionInfo allDifferentRestrictionInfo = new AllDifferentRestrictionInfo();
                for (RDFIndividual individual : owlAllDifferent.getDistinctMembers()) {
                    allDifferentRestrictionInfo.addIndividualName(individual.getName());
                }
                this.importedRestrictions.add(allDifferentRestrictionInfo);
            }
        }
    }

    private void exportSWRLRules() throws SWRLRuleEngineBridgeException {
        for (RuleInfo ruleInfo : this.importedSWRLRules) {
            this.defineRule(ruleInfo);
        }
    }

    private void exportOWLClasses() throws SWRLRuleEngineBridgeException {
        for (ClassInfo classInfo : this.importedClasses.values()) {
            this.exportOWLClass(classInfo);
        }
    }

    private void exportOWLClass(ClassInfo classInfo) throws SWRLRuleEngineBridgeException {
        String className = classInfo.getName();
        List superClassNames = classInfo.getDirectSuperClassNames();
        if (!this.exportedClassNames.contains(className)) {
            if (!superClassNames.isEmpty()) {
                for (String superClassName : superClassNames) {
                    ClassInfo superClassInfo = (ClassInfo)this.importedClasses.get(superClassName);
                    this.exportOWLClass(superClassInfo);
                }
            }
            this.defineClass(classInfo);
            this.exportedClassNames.add(className);
        }
    }

    private void exportOWLProperties() throws SWRLRuleEngineBridgeException {
        for (PropertyInfo propertyInfo : this.importedProperties) {
            String propertyName = propertyInfo.getName();
            this.defineProperty(propertyInfo);
        }
    }

    private void exportOWLIndividuals() throws SWRLRuleEngineBridgeException {
        for (IndividualInfo individualInfo : this.importedIndividuals.values()) {
            String individualName = individualInfo.getName();
            if (this.exportedIndividualNames.contains(individualName)) continue;
            this.defineIndividual(individualInfo);
            this.exportedIndividualNames.add(individualName);
        }
    }

    private void exportOWLRestrictions() throws SWRLRuleEngineBridgeException {
        for (RestrictionInfo restrictionInfo : this.importedRestrictions) {
            this.defineRestriction(restrictionInfo);
        }
    }

    private void writeAssertedProperties2OWL() throws SWRLRuleEngineBridgeException {
        for (PropertyInfo propertyInfo : this.assertedProperties) {
            propertyInfo.write2OWL(this.owlModel);
        }
    }

    private void writeAssertedIndividuals2OWL() throws SWRLRuleEngineBridgeException {
        for (IndividualInfo individualInfo : this.assertedIndividuals) {
            individualInfo.write2OWL(this.owlModel);
        }
    }

    private void preProcessAtoms(RuleInfo ruleInfo) throws SWRLRuleEngineBridgeException {
        ArrayList bodyAtoms = new ArrayList();
        ArrayList headAtoms = new ArrayList();
        ArrayList<AtomInfo> nonBuiltInBodyAtoms = new ArrayList<AtomInfo>();
        ArrayList<AtomInfo> builtInAtoms = new ArrayList<AtomInfo>();
        ArrayList<BuiltInAtomInfo> builtInWithoutAssignmentAtoms = new ArrayList<BuiltInAtomInfo>();
        ArrayList<BuiltInAtomInfo> builtInWithAssignmentAtoms = new ArrayList<BuiltInAtomInfo>();
        ArrayList variableNamesUsedByNonBuiltInAtoms = new ArrayList();
        ArrayList<String> assignedBuiltInVariableNames = new ArrayList<String>();
        for (AtomInfo atomInfo : ruleInfo.getBodyAtoms()) {
            if (atomInfo instanceof BuiltInAtomInfo) {
                builtInAtoms.add(atomInfo);
                continue;
            }
            nonBuiltInBodyAtoms.add(atomInfo);
            variableNamesUsedByNonBuiltInAtoms.addAll(atomInfo.getReferencedVariableNames());
        }
        for (BuiltInAtomInfo builtInAtomInfo : builtInAtoms) {
            List variableNamesUsedByBuiltIn = builtInAtomInfo.getReferencedVariableNames();
            if (builtInAtomInfo.isFirstArgumentAVariable()) {
                String firstArgumentVariableName = builtInAtomInfo.getFirstArgumentVariableName();
                if (!variableNamesUsedByNonBuiltInAtoms.contains(firstArgumentVariableName)) {
                    if (assignedBuiltInVariableNames.contains(firstArgumentVariableName)) {
                        throw new SWRLRuleEngineBridgeException("Attempt to set variable ?" + firstArgumentVariableName + " for second time by built-in '" + builtInAtomInfo.getName() + "'.");
                    }
                    assignedBuiltInVariableNames.add(firstArgumentVariableName);
                    builtInWithAssignmentAtoms.add(builtInAtomInfo);
                    variableNamesUsedByBuiltIn.remove(0);
                } else {
                    builtInWithoutAssignmentAtoms.add(builtInAtomInfo);
                }
            } else {
                builtInWithoutAssignmentAtoms.add(builtInAtomInfo);
            }
            for (String variableName : variableNamesUsedByBuiltIn) {
                if (variableNamesUsedByNonBuiltInAtoms.contains(variableName)) continue;
                throw new SWRLRuleEngineBridgeException("Variable ?" + variableName + " in by built-in '" + builtInAtomInfo.getName() + "' used before definition.");
            }
        }
        bodyAtoms.addAll(nonBuiltInBodyAtoms);
        bodyAtoms.addAll(builtInWithoutAssignmentAtoms);
        headAtoms.addAll(builtInWithAssignmentAtoms);
        headAtoms.addAll(ruleInfo.getHeadAtoms());
        ruleInfo.setBodyAtoms(bodyAtoms);
        ruleInfo.setHeadAtoms(headAtoms);
    }

    private void clearExportedAndAssertedKnowledge() {
        this.exportedClassNames.clear();
        this.exportedIndividualNames.clear();
        this.assertedProperties.clear();
        this.assertedIndividuals.clear();
    }

    private boolean isBuiltIn(String builtInName) {
        RDFResource resource = this.owlModel.getRDFResource(builtInName);
        return resource != null && resource.getProtegeType().getName().equals("swrl:Builtin");
    }

    private boolean isObjectProperty(String propertyName) throws SWRLRuleEngineBridgeException {
        OWLProperty property = this.owlModel.getOWLProperty(propertyName);
        if (property == null) {
            throw new InvalidPropertyNameException(propertyName);
        }
        return property.isObjectProperty();
    }

    private void checkBuiltInMethod(String namespaceName, String builtInMethodName, Method method) throws IncompatibleBuiltInMethodException {
        if (method.getReturnType() != Boolean.TYPE) {
            throw new IncompatibleBuiltInMethodException(namespaceName, builtInMethodName, "Method does not return a boolean.");
        }
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        if (exceptionTypes.length != 1 || exceptionTypes[0] != BuiltInException.class) {
            throw new IncompatibleBuiltInMethodException(namespaceName, builtInMethodName, "Built-in method must throw a single exception of type BuiltInException.");
        }
    }

    private void checkBuiltInClass(String namespaceName, Class cls) throws IncompatibleBuiltInClassException {
        if (!SWRLBuiltInMethods.class.isAssignableFrom(cls)) {
            throw new IncompatibleBuiltInClassException(namespaceName, cls.getName(), "Class does not implement SWRLBuiltInMethods.");
        }
    }
}

