/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltinAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.DefaultSWRLAtom;
import edu.stanford.smi.protegex.owl.swrl.model.impl.SWRLUtil;
import java.util.Set;

public class DefaultSWRLBuiltinAtom
extends DefaultSWRLAtom
implements SWRLBuiltinAtom {
    public DefaultSWRLBuiltinAtom(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultSWRLBuiltinAtom() {
    }

    public void getReferencedInstances(Set set) {
        SWRLBuiltin builtin;
        RDFList arguments = this.getArguments();
        if (arguments != null) {
            int size = arguments.size();
            while (size > 0) {
                Object first = arguments.getFirst();
                if (first instanceof RDFResource) {
                    set.add(first);
                }
                arguments = arguments.getRest();
                --size;
            }
        }
        if ((builtin = this.getBuiltin()) != null) {
            set.add(builtin);
        }
    }

    public RDFList getArguments() {
        return (RDFList)this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:arguments"));
    }

    public void setArguments(RDFList arguments) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:arguments"), arguments);
    }

    public SWRLBuiltin getBuiltin() {
        return (SWRLBuiltin)this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:builtin"));
    }

    public void setBuiltin(SWRLBuiltin swrlBuiltin) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:builtin"), swrlBuiltin);
    }

    public String getBrowserText() {
        String s = "";
        if (this.getBuiltin() == null || this.getArguments() == null) {
            return super.getBrowserText();
        }
        s = String.valueOf(s) + this.getBuiltin().getBrowserText() + "(";
        RDFList list = this.getArguments();
        int i = list.size();
        while (i > 0) {
            Object o = list.getFirst();
            if (o instanceof RDFResource) {
                s = String.valueOf(s) + ((RDFResource)o).getBrowserText();
            } else {
                RDFSLiteral l = list.getFirstLiteral();
                s = String.valueOf(s) + SWRLUtil.getSWRLBrowserText(l);
            }
            list = list.getRest();
            if (list.size() > 0) {
                s = String.valueOf(s) + ", ";
            }
            --i;
        }
        s = String.valueOf(s) + ")";
        return s;
    }
}

