/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.swrl.model.impl;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.impl.DefaultOWLIndividual;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLAtomList;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLBuiltin;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLImp;
import edu.stanford.smi.protegex.owl.swrl.model.SWRLIndividual;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParseException;
import edu.stanford.smi.protegex.owl.swrl.parser.SWRLParser;
import edu.stanford.smi.protegex.owl.swrl.ui.icons.SWRLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;

public class DefaultSWRLImp
extends DefaultOWLIndividual
implements SWRLImp {
    public DefaultSWRLImp(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultSWRLImp() {
    }

    public SWRLImp createClone() {
        String text = this.getBrowserText();
        OWLModel owlModel = (OWLModel)this.getKnowledgeBase();
        SWRLParser parser = new SWRLParser(owlModel);
        parser.setParseOnly(false);
        try {
            return parser.parse(text);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void deleteHeadAndBody() {
        Slot directInstancesSlot = this.getKnowledgeBase().getSlot(":DIRECT-INSTANCES");
        Set instances = this.getReferencedInstances();
        for (Object o : instances) {
            SWRLIndividual swrlIndividual;
            if (!(o instanceof SWRLIndividual) || o instanceof SWRLBuiltin || (swrlIndividual = (SWRLIndividual)o).isDeleted()) continue;
            Collection references = this.getKnowledgeBase().getReferences((Object)swrlIndividual, -1);
            boolean hasExternalRef = false;
            for (Reference reference : references) {
                Frame frame;
                if (directInstancesSlot.equals(reference.getSlot()) || instances.contains(frame = reference.getFrame()) || this.equals(frame)) continue;
                hasExternalRef = true;
            }
            if (hasExternalRef) continue;
            swrlIndividual.delete();
        }
    }

    public void deleteImp() {
        this.deleteHeadAndBody();
        this.delete();
    }

    public SWRLAtomList getHead() {
        return (SWRLAtomList)this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:head"));
    }

    public Icon getIcon() {
        return this.isEditable() ? SWRLIcons.getImpIcon() : OWLIcons.getReadOnlyIcon(SWRLIcons.getImpIcon(), "RoundedBoxFrame");
    }

    public Set getReferencedInstances() {
        HashSet set = new HashSet();
        this.getReferencedInstances(set);
        return set;
    }

    public void getReferencedInstances(Set set) {
        SWRLAtomList body;
        SWRLAtomList head = this.getHead();
        if (head != null) {
            set.add(head);
            head.getReferencedInstances(set);
        }
        if ((body = this.getBody()) != null) {
            set.add(body);
            body.getReferencedInstances(set);
        }
    }

    public SWRLAtomList getBody() {
        return (SWRLAtomList)this.getPropertyValue(this.getOWLModel().getRDFProperty("swrl:body"));
    }

    public void setBody(SWRLAtomList swrlAtomList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:body"), swrlAtomList);
    }

    public String getBrowserText() {
        SWRLAtomList body = this.getBody();
        SWRLAtomList head = this.getHead();
        if (body == null) {
            if (head == null) {
                return "<empty rule>";
            }
            return head.getBrowserText();
        }
        String s = String.valueOf(body.getBrowserText()) + "  " + '\u2192' + "  ";
        if (head == null) {
            return String.valueOf(s) + "<null>";
        }
        s = String.valueOf(s) + head.getBrowserText();
        return s;
    }

    public void setHead(SWRLAtomList swrlAtomList) {
        this.setPropertyValue(this.getOWLModel().getRDFProperty("swrl:head"), swrlAtomList);
    }

    public void setExpression(String parsableText) throws SWRLParseException {
        SWRLParser parser = new SWRLParser(this.getOWLModel());
        parser.parse(parsableText);
        this.deleteHeadAndBody();
        parser.setParseOnly(false);
        parser.parse(parsableText, this);
    }
}

