/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.todo;

import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TodoAnnotationOWLTest
extends AbstractOWLTest
implements RDFResourceTest {
    public static final String GROUP = "Maintenance Tests";

    public TodoAnnotationOWLTest() {
        super(GROUP, null);
    }

    public String getName() {
        return "Find TODO list items";
    }

    public static List getTODOListItems(RDFResource instance) {
        ArrayList results = new ArrayList();
        OWLModel owlModel = instance.getOWLModel();
        OWLDatatypeProperty property = owlModel.getTodoAnnotationProperty();
        String prefix = owlModel.getTodoAnnotationPrefix();
        for (Object value : instance.getPropertyValues(property)) {
            String str = null;
            if (value instanceof RDFSLiteral) {
                str = ((RDFSLiteral)value).getString();
                value = str;
            } else {
                str = value.toString();
            }
            if (!str.startsWith(prefix)) continue;
            results.add(value);
        }
        return results;
    }

    public List test(RDFResource instance) {
        List items = TodoAnnotationOWLTest.getTODOListItems(instance);
        if (items.size() > 0) {
            ArrayList<1> results = new ArrayList<1>();
            for (final String str : items) {
                results.add(new DefaultOWLTestResult(str, instance, 2, this, OWLIcons.getTODOIcon()){

                    public String toString() {
                        return "TODO (at " + this.getHost().getBrowserText() + "): " + str;
                    }
                });
            }
            return results;
        }
        return Collections.EMPTY_LIST;
    }
}

