/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.actions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.awt.Component;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class ResourceAction
extends AbstractAction
implements Comparable {
    private Component component;
    private String group;
    private boolean inToolBar;
    private RDFResource resource;

    public ResourceAction(String name, Icon icon) {
        this(name, icon, null);
    }

    public ResourceAction(String name, Icon icon, String group) {
        this(name, icon, group, false);
    }

    public ResourceAction(String name, Icon icon, String group, boolean inToolBar) {
        super(name, icon);
        this.group = group;
        this.inToolBar = inToolBar;
    }

    public int compareTo(Object o) {
        if (o instanceof ResourceAction) {
            String otherGroup;
            ResourceAction other = (ResourceAction)o;
            String thisGroup = this.getGroup();
            if (thisGroup == null) {
                thisGroup = "";
            }
            if ((otherGroup = other.getGroup()) == null) {
                otherGroup = "";
            }
            String thisName = (String)this.getValue("Name");
            String otherName = (String)other.getValue("Name");
            int groupCompare = thisGroup.compareTo(otherGroup);
            if (groupCompare == 0) {
                int result = new Integer(other.getPriority()).compareTo(new Integer(this.getPriority()));
                if (result != 0) {
                    return result;
                }
                return thisName.compareTo(otherName);
            }
            return groupCompare;
        }
        return 0;
    }

    protected Component getComponent() {
        return this.component;
    }

    public String getGroup() {
        return this.group;
    }

    public int getPriority() {
        return 0;
    }

    public OWLModel getOWLModel() {
        if (this.resource != null) {
            return this.resource.getOWLModel();
        }
        return null;
    }

    protected RDFResource getResource() {
        return this.resource;
    }

    public void initialize(Component component, RDFResource resource) {
        this.component = component;
        this.resource = resource;
    }

    public boolean isInToolBar() {
        return this.inToolBar;
    }

    public abstract boolean isSuitable(Component var1, RDFResource var2);
}

