/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;

public class ConvertToPrimitiveClassAction
extends ResourceAction {
    public ConvertToPrimitiveClassAction() {
        super("Convert to primitive class", OWLIcons.getImageIcon("PrimitiveClass"), "Edit", true);
    }

    public void actionPerformed(ActionEvent e) {
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab(this.getComponent());
        try {
            try {
                OWLNamedClass cls = (OWLNamedClass)this.getResource();
                this.getOWLModel().beginTransaction("Convert " + cls.getBrowserText() + " to primitive class");
                ConvertToPrimitiveClassAction.performAction(cls);
            }
            catch (Exception ex) {
                OWLUI.handleError(this.getOWLModel(), ex);
            }
        }
        finally {
            this.getOWLModel().endTransaction();
        }
        if (tab != null) {
            tab.ensureClassSelected((OWLNamedClass)this.getResource(), -1);
        }
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        return component instanceof ResourceDisplay && resource instanceof OWLNamedClass && resource.isEditable() && ((OWLNamedClass)resource).getDefinition() != null;
    }

    public static void performAction(OWLNamedClass cls) {
        ArrayList equis = new ArrayList(cls.getEquivalentClasses());
        for (RDFSClass equiClass : equis) {
            if (equiClass instanceof OWLIntersectionClass) {
                OWLIntersectionClass intersectionClass = (OWLIntersectionClass)equiClass;
                Collection operands = intersectionClass.getOperands();
                for (RDFSClass operand : operands) {
                    cls.addSuperclass(operand.createClone());
                }
                intersectionClass.delete();
                for (RDFSClass operand : operands) {
                    if (!(operand instanceof RDFSNamedClass)) continue;
                    cls.addSuperclass(operand);
                }
                continue;
            }
            if (equiClass == null) continue;
            equiClass.removeSuperclass(cls);
            if (!(equiClass instanceof RDFSNamedClass) || equiClass.getSuperclassCount() != 0) continue;
            equiClass.addSuperclass(equiClass.getOWLModel().getOWLThingClass());
        }
    }
}

