/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.ui.ResourceComparator;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;

public class ComponentUtil {
    public static JComboBox createDatatypeComboBox(OWLModel owlModel) {
        ArrayList types = new ArrayList(owlModel.getRDFSDatatypes());
        types.remove(owlModel.getRDFXMLLiteralType());
        Collections.sort(types, new ResourceComparator());
        JComboBox<Object> datatypeComboBox = new JComboBox<Object>(types.toArray());
        datatypeComboBox.setRenderer(new DatatypeCellRenderer());
        datatypeComboBox.setSelectedItem(owlModel.getXSDstring());
        return datatypeComboBox;
    }

    public static JComboBox createLanguageComboBox(OWLModel owlModel) {
        return ComponentUtil.createLanguageComboBox(owlModel, null);
    }

    public static JComboBox createLanguageComboBox(OWLModel owlModel, String initialSelection) {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem("");
        comboBox.setEditable(true);
        String[] languages = owlModel.getUsedLanguages();
        int i = 0;
        while (i < languages.length) {
            String language = languages[i];
            comboBox.addItem(language);
            ++i;
        }
        if (initialSelection != null) {
            comboBox.setSelectedItem(initialSelection);
        }
        return comboBox;
    }

    public static boolean isRangeDefined(RDFResource resource, RDFProperty property) {
        if (property.getRange() != null) {
            return true;
        }
        Collection types = resource.getRDFTypes();
        for (RDFSClass type : types) {
            OWLNamedClass namedClass;
            RDFResource allValuesFrom;
            if (!(type instanceof OWLNamedClass) || (allValuesFrom = (namedClass = (OWLNamedClass)type).getAllValuesFrom(property)) == null) continue;
            return true;
        }
        return false;
    }

    public static JComboBox createLangCellEditor(OWLModel owlModel, JTable table) {
        JComboBox comboBox = ComponentUtil.createLanguageComboBox(owlModel, null);
        comboBox.setFont(table.getFont());
        comboBox.setBackground(table.getBackground());
        return comboBox;
    }

    public static class DatatypeCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof RDFSDatatype) {
                value = ((RDFSDatatype)value).getLocalName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

