/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.literaltable;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.AddResourceAction;
import edu.stanford.smi.protegex.owl.ui.components.AddablePropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.literaltable.LiteralTable;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditor;
import edu.stanford.smi.protegex.owl.ui.editors.PropertyValueEditorManager;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LiteralTableComponent
extends AddablePropertyValuesComponent {
    private Action addAction = new AbstractAction("Add new value", OWLIcons.getAddIcon()){

        public void actionPerformed(ActionEvent e) {
            LiteralTableComponent.this.handleAddAction();
        }
    };
    private Action deleteAction = new AbstractAction("Delete selected value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent e) {
            LiteralTableComponent.this.handleDeleteAction();
        }
    };
    private LiteralTable table;
    private Action viewAction = new AbstractAction("View/edit selected value...", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            LiteralTableComponent.this.handleViewAction();
        }
    };

    public LiteralTableComponent(RDFProperty predicate) {
        super(predicate);
        this.table = new LiteralTable(predicate);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                LiteralTableComponent.this.updateActionsState();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LiteralTableComponent.this.handleDoubleClick();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(Color.white);
        OWLLabeledComponent lc = new OWLLabeledComponent(this.getLabel(), scrollPane);
        lc.addHeaderButton(this.viewAction);
        lc.addHeaderButton(this.addAction);
        if (!(predicate instanceof OWLProperty) && predicate.getRange() == null) {
            lc.addHeaderButton(new AddResourceAction(this, false));
        }
        lc.addHeaderButton(this.deleteAction);
        this.add((Component)((Object)lc));
        this.updateActionsState();
    }

    private Object createDefaultValue() {
        RDFProperty property = this.getPredicate();
        Iterator it = PropertyValueEditorManager.listEditors();
        while (it.hasNext()) {
            Object defaultValue;
            PropertyValueEditor plugin = (PropertyValueEditor)it.next();
            if (!plugin.canEdit(this.getSubject(), property, null) || (defaultValue = plugin.createDefaultValue(this.getSubject(), property)) == null) continue;
            return defaultValue;
        }
        RDFResource range = property.getRange();
        if (range instanceof RDFSDatatype) {
            return ((RDFSDatatype)range).getDefaultValue();
        }
        if (range instanceof OWLDataRange) {
            OWLDataRange dataRange = (OWLDataRange)range;
            RDFList oneOf = dataRange.getOneOf();
            Object defaultValue = null;
            if (oneOf != null) {
                RDFResource subj = this.getSubject();
                RDFProperty pred = this.getPredicate();
                Iterator values = oneOf.getValues().iterator();
                while (values.hasNext() && defaultValue == null) {
                    Object value = values.next();
                    if (subj.hasPropertyValue(pred, value)) continue;
                    defaultValue = value;
                }
                if (defaultValue == null) {
                    ProtegeUI.getModalDialogFactory().showMessageDialog(this.getOWLModel(), "You have already assigned all allowed values");
                }
            }
            return defaultValue;
        }
        if (property instanceof OWLObjectProperty) {
            return null;
        }
        return "";
    }

    private void handleAddAction() {
        Object defaultValue = this.createDefaultValue();
        if (defaultValue != null && !this.getObjects().contains(defaultValue)) {
            this.getSubject().addPropertyValue(this.getPredicate(), defaultValue);
            this.table.setSelectedRow(defaultValue);
            if (!"".equals(defaultValue)) {
                Iterator it = PropertyValueEditorManager.listEditors();
                while (it.hasNext()) {
                    PropertyValueEditor editor = (PropertyValueEditor)it.next();
                    if (!editor.canEdit(this.getSubject(), this.getPredicate(), null)) continue;
                    Object newValue = editor.editValue(this, this.getSubject(), this.getPredicate(), defaultValue);
                    if (newValue != null) {
                        this.getSubject().removePropertyValue(this.getPredicate(), defaultValue);
                        this.getSubject().addPropertyValue(this.getPredicate(), newValue);
                        this.table.setSelectedRow(newValue);
                    }
                    return;
                }
            }
            this.table.editCell(defaultValue);
        }
    }

    private void handleDeleteAction() {
        List values = this.getOWLModel().asRDFSLiterals(this.getObjects());
        int[] sels = this.table.getSelectedRows();
        int i = 0;
        while (i < sels.length) {
            int row = sels[i];
            if (row >= 0 && row < this.table.getTableModel().getRowCount()) {
                Object value = this.table.getTableModel().getObject(row);
                values.remove(value);
            }
            ++i;
        }
        this.getSubject().setPropertyValues(this.getPredicate(), values);
    }

    protected void handleDoubleClick() {
        int[] sel = this.table.getSelectedRows();
        if (sel.length == 1 && this.viewAction.isEnabled() && !this.table.getTableModel().isCellEditable(sel[0], 0)) {
            this.handleViewAction();
        }
    }

    protected void handleViewAction() {
        int[] sel = this.table.getSelectedRows();
        if (sel.length > 0) {
            this.table.stopEditing();
            Object oldValue = this.table.getTableModel().getObject(sel[0]);
            if (oldValue instanceof RDFResource) {
                RDFResource resource = (RDFResource)oldValue;
                resource.getProject().show((Instance)resource);
            } else {
                Object newValue;
                PropertyValueEditor editor = this.getEditor(oldValue);
                if (editor != null && (newValue = editor.editValue(null, this.getSubject(), this.getPredicate(), oldValue)) != null) {
                    Object neo;
                    if (oldValue instanceof RDFSLiteral && (neo = ((RDFSLiteral)oldValue).getPlainValue()) != null) {
                        oldValue = neo;
                    }
                    this.getSubject().removePropertyValue(this.getPredicate(), oldValue);
                    this.getSubject().addPropertyValue(this.getPredicate(), newValue);
                    this.table.setSelectedRow(newValue);
                }
            }
        }
    }

    public void setSubject(RDFResource subject) {
        super.setSubject(subject);
        this.table.setSubject(subject);
    }

    private void updateActionsState() {
        int[] sel = this.table.getSelectedRows();
        boolean deleteEnabled = this.table.getTableModel().isDeleteEnabled(sel);
        this.deleteAction.setEnabled(deleteEnabled);
        TripleStoreModel tsm = this.getOWLModel().getTripleStoreModel();
        boolean viewEnabled = false;
        if (sel.length == 1) {
            Object object = this.table.getTableModel().getObject(sel[0]);
            if (object instanceof RDFResource) {
                viewEnabled = true;
            } else if (this.getSubject().getAllValuesFromOnTypes(this.getPredicate()) instanceof OWLDataRange) {
                viewEnabled = false;
            } else {
                PropertyValueEditor editor = this.getEditor(object);
                if (editor != null) {
                    viewEnabled = tsm.isActiveTriple(this.getSubject(), this.getPredicate(), object);
                }
            }
        }
        this.viewAction.setEnabled(viewEnabled);
    }

    public void valuesChanged() {
        this.table.getTableModel().updateValues();
    }
}

