/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFUntypedResource;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.metadata.AnnotationsWidgetPlugin;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Icon;

public class CreateValueAction
extends ResourceSelectionAction {
    protected TriplesTable table;

    public CreateValueAction(TriplesTable table) {
        this(table, "Create new property value...", OWLIcons.getCreateIcon("Triple"));
    }

    public CreateValueAction(TriplesTable table, String name, Icon icon) {
        super(name, icon);
        this.table = table;
    }

    protected Collection getAllowedProperties(OWLModel owlModel) {
        Collection allowedProperties = owlModel.getRDFProperties();
        ArrayList<RDFProperty> properties = new ArrayList<RDFProperty>();
        for (RDFProperty property : allowedProperties) {
            if (!property.isVisible() || !property.hasObjectRange()) continue;
            properties.add(property);
        }
        return properties;
    }

    public Collection getSelectableResources() {
        TriplesTableModel tableModel = this.table.getTableModel();
        OWLModel owlModel = tableModel.getOWLModel();
        Collection allowedProperties = this.getAllowedProperties(owlModel);
        return allowedProperties;
    }

    protected void handleCreateAction(RDFProperty property) {
        TriplesTableModel tableModel = this.table.getTableModel();
        OWLModel owlModel = tableModel.getOWLModel();
        RDFSClass cls = null;
        if (property.hasObjectRange()) {
            Collection classes = property.getUnionRangeClasses();
            if (OWLUI.isExternalResourcesSupported(owlModel)) {
                owlModel.getRDFUntypedResourcesClass().setVisible(true);
            }
            cls = ProtegeUI.getSelectionDialogFactory().selectClass((Component)this.table, owlModel, classes, "Select class of new value");
            owlModel.getRDFUntypedResourcesClass().setVisible(false);
        }
        if (cls != null) {
            RDFResource resource = cls.createInstance(null);
            if (resource instanceof RDFSClass) {
                RDFSClass newClass = (RDFSClass)resource;
                if (newClass.getSuperclassCount() == 0) {
                    newClass.addSuperclass(owlModel.getOWLThingClass());
                }
            } else if (resource instanceof OWLOntology) {
                String defaultNS = owlModel.getNamespaceManager().getDefaultNamespace();
                if (defaultNS.endsWith("#")) {
                    defaultNS = defaultNS.substring(0, defaultNS.length() - 1);
                }
                String prefixBase = "ontology";
                int index = 0;
                String prefix = prefixBase;
                while (owlModel.getNamespaceManager().getNamespaceForPrefix(prefixBase) != null) {
                    prefix = String.valueOf(prefixBase) + index++;
                }
                String nsBase = "http://www.owl-ontologies.com/unnamed.owl";
                String ns = String.valueOf(nsBase) + "#";
                while (owlModel.getNamespaceManager().getPrefix(ns) != null) {
                    ns = String.valueOf(nsBase) + index + "#";
                }
                owlModel.getNamespaceManager().setPrefix(ns, prefix);
                OWLOntology ontology = (OWLOntology)resource;
                ontology.setName(String.valueOf(prefix) + ":");
            } else if (resource instanceof RDFUntypedResource) {
                OWLUtil.assignUniqueURI((RDFUntypedResource)resource);
            }
            owlModel.getProject().show((Instance)resource);
            int row = tableModel.addRow(property, resource);
            this.table.getSelectionModel().setSelectionInterval(row, row);
            this.table.scrollRectToVisible(this.table.getCellRect(row, 0, true));
        }
    }

    public RDFResource pickResource() {
        TriplesTableModel tableModel = this.table.getTableModel();
        OWLModel owlModel = tableModel.getOWLModel();
        Collection resources = this.getSelectableResources();
        return ProtegeUI.getSelectionDialogFactory().selectProperty(this.table, owlModel, resources);
    }

    public void resourceSelected(RDFResource resource) {
        TriplesTableModel tableModel = this.table.getTableModel();
        RDFProperty property = (RDFProperty)resource;
        if (property instanceof OWLObjectProperty) {
            this.handleCreateAction(property);
        } else {
            int row = tableModel.addRow(property);
            if (row >= 0) {
                Object value = tableModel.getValue(row);
                Iterator it = TriplesComponent.plugins();
                while (it.hasNext()) {
                    AnnotationsWidgetPlugin plugin = (AnnotationsWidgetPlugin)it.next();
                    if (!plugin.canEdit(tableModel.getSubject(), property, value)) continue;
                    Object newValue = plugin.editValue(null, tableModel.getSubject(), property, value);
                    if (newValue != null) {
                        tableModel.setValue(newValue, row);
                    }
                    return;
                }
                this.table.editCell(row);
            } else {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(resource.getOWLModel(), "Could not create default value for " + property.getBrowserText());
            }
        }
    }
}

