/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.ResourceAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class AddCoveringAxiomAction
extends ResourceAction {
    public AddCoveringAxiomAction() {
        super("Add covering axiom", OWLIcons.getImageIcon("OWLUnionClass"), "Edit", true);
    }

    public void actionPerformed(ActionEvent e) {
        OWLNamedClass namedClass = (OWLNamedClass)this.getResource();
        if (this.isSuitable(this.getComponent(), namedClass)) {
            AddCoveringAxiomAction.performAction(namedClass);
        }
    }

    private Set getOperandsStringSet(Iterator os) {
        HashSet<String> existingOperands = new HashSet<String>();
        while (os.hasNext()) {
            RDFSClass operand = (RDFSClass)os.next();
            existingOperands.add(operand.getBrowserText());
        }
        return existingOperands;
    }

    private static List getPureSubclasses(OWLNamedClass namedClass) {
        Collection subclasses = namedClass.getSubclasses(false);
        ArrayList pureSubclasses = new ArrayList(subclasses);
        pureSubclasses.removeAll(namedClass.getEquivalentClasses());
        return pureSubclasses;
    }

    public boolean isSuitable(Component component, RDFResource resource) {
        OWLNamedClass namedClass;
        List pures;
        if (component instanceof ResourceDisplay && resource instanceof OWLNamedClass && !resource.isSystem() && (pures = AddCoveringAxiomAction.getPureSubclasses(namedClass = (OWLNamedClass)resource)).size() > 1) {
            Set newOperands = this.getOperandsStringSet(pures.iterator());
            for (RDFSClass equi : namedClass.getEquivalentClasses()) {
                Iterator os;
                Set existingOperands;
                if (!(equi instanceof OWLUnionClass) || !newOperands.equals(existingOperands = this.getOperandsStringSet(os = ((OWLUnionClass)equi).getOperands().iterator()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void performAction(OWLNamedClass namedClass) {
        List pures = AddCoveringAxiomAction.getPureSubclasses(namedClass);
        if (pures.size() > 1) {
            OWLModel owlModel = namedClass.getOWLModel();
            try {
                try {
                    owlModel.beginTransaction("Add covering axiom for " + namedClass.getBrowserText());
                    OWLUnionClass unionClass = namedClass.getOWLModel().createOWLUnionClass();
                    for (RDFSClass subclass : pures) {
                        RDFSClass c = subclass.createClone();
                        unionClass.addOperand(c);
                    }
                    namedClass.addEquivalentClass(unionClass);
                }
                catch (Exception ex) {
                    OWLUI.handleError(owlModel, ex);
                }
            }
            finally {
                owlModel.endTransaction();
            }
        } else {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(namedClass.getOWLModel(), "The class " + namedClass.getBrowserText() + " has less than 2 pure subclasses.");
        }
    }
}

