/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTable;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableConstants;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableTransferHandler;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.JTable;

public class ConditionsTableTransferHandler
extends OWLTableTransferHandler
implements ConditionsTableConstants {
    private String movedClsText;
    private String movedClsBlock;
    private boolean movedClsWasDefinition;
    private OWLNamedClass movedNamedCls;
    private boolean movedNamedClsHadThingAsSuperClass;
    private int recentTargetRow;
    private int recentTargetType;
    public Transferable recentTransferable;

    public ConditionsTableTransferHandler(OWLModel owlModel) {
        super(owlModel);
    }

    protected boolean addRow(OWLTableModel tableModel, RDFSClass clone, int index) {
        this.recentTargetType = ((ConditionsTableModel)tableModel).getType(index);
        return ((ConditionsTableModel)tableModel).addRowAllowMove(clone, index);
    }

    public void cleanup(JComponent c, boolean remove) {
        OWLTable source = (OWLTable)((Object)c);
        OWLClassesTab tab = ((ConditionsTable)source).getOWLClsesTab();
        if (remove && this.rows != null) {
            this.cleanup(source);
            this.movedClsBlock = null;
            this.movedClsText = null;
            this.recentTargetType = -10;
        }
        ((ConditionsTable)source).ensureEditedClassSelectedInExplorer(tab);
        super.cleanup(c, remove);
        this.movedNamedCls = null;
    }

    private void cleanup(OWLTable source) {
        int index;
        ConditionsTableModel tableModel = (ConditionsTableModel)source.getModel();
        String oldBrowserText = null;
        int oldSelection = source.getSelectedRow();
        if (oldSelection >= 0 && tableModel.getClass(oldSelection) != null) {
            oldBrowserText = tableModel.getClass(oldSelection).getBrowserText();
        }
        if ((index = this.getDeleteRowIndex(tableModel)) >= 0) {
            if (tableModel.isDefinition(index) && tableModel.getClass(index) instanceof OWLNamedClass && this.recentTargetType == -1 && tableModel.getDefinition(index) == null) {
                RDFSClass cls = tableModel.getClass(index);
                cls.removeDirectSuperclass(tableModel.getEditedCls());
            } else {
                tableModel.deleteRow(index, true);
            }
            if (this.movedNamedCls != null && this.recentTargetType == -1) {
                tableModel.getEditedCls().addSuperclass(this.movedNamedCls);
                if (!this.movedNamedClsHadThingAsSuperClass) {
                    tableModel.getEditedCls().removeSuperclass(this.getRootCls());
                }
            }
            if (this.movedNamedCls != null && this.recentTargetRow == 0) {
                tableModel.getEditedCls().addEquivalentClass(this.movedNamedCls);
                if (!this.movedNamedClsHadThingAsSuperClass) {
                    tableModel.getEditedCls().removeSuperclass(this.getRootCls());
                }
            }
        }
        if (oldBrowserText != null) {
            source.setSelectedRow(oldBrowserText);
        }
    }

    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        ConditionsTable table = (ConditionsTable)((Object)comp);
        ConditionsTableModel tableModel = (ConditionsTableModel)table.getModel();
        int sel = table.getSelectedRow();
        if (sel >= 0 && tableModel.getClass(sel) instanceof OWLNamedClass && tableModel.isDefinition(sel)) {
            this.movedNamedCls = (OWLNamedClass)tableModel.getClass(sel);
            this.movedNamedClsHadThingAsSuperClass = tableModel.getEditedCls().getSuperclasses(false).contains(this.getRootCls());
        }
        super.exportAsDrag(comp, e, action);
    }

    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        this.movedNamedCls = null;
        super.exportToClipboard(comp, clip, action);
    }

    protected Transferable exportOWLClses(JComponent c) {
        JTable table = (JTable)c;
        ConditionsTableModel tableModel = (ConditionsTableModel)table.getModel();
        int row = table.getSelectedRow();
        if (row >= 0 && tableModel.getClass(row) != null && tableModel.getType(row) != -2) {
            this.movedClsText = tableModel.getClass(row).getBrowserText();
            this.movedClsBlock = tableModel.getBlockText(tableModel.getType(row));
            this.movedClsWasDefinition = tableModel.isDefinition(row);
        }
        this.recentTransferable = super.exportOWLClses(c);
        return this.recentTransferable;
    }

    private int getDeleteRowIndex(ConditionsTableModel tableModel) {
        int expectedType = -1;
        if (this.movedClsWasDefinition) {
            if (this.movedClsBlock == null) {
                return -1;
            }
            expectedType = 0;
            while (!this.movedClsBlock.equals(tableModel.getBlockText(expectedType))) {
                ++expectedType;
            }
        }
        int i = 0;
        while (i < tableModel.getRowCount()) {
            RDFSClass cls = tableModel.getClass(i);
            if (cls != null && tableModel.getType(i) == expectedType && cls.getBrowserText().equals(this.movedClsText)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int importOWLClses(JComponent c, String clsesText) {
        ConditionsTable table = (ConditionsTable)((Object)c);
        this.recentTargetRow = table.getSelectedRow();
        OWLClassesTab tab = ((ConditionsTable)((Object)c)).getOWLClsesTab();
        int result = super.importOWLClses(c, clsesText);
        ((ConditionsTable)((Object)c)).ensureEditedClassSelectedInExplorer(tab);
        return result;
    }
}

