/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.explorer.filter;

import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.explorer.filter.DefaultExplorerFilter;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ValidClassesPanel
extends JPanel {
    private DefaultExplorerFilter filter;
    private JList list;
    public static final int PREFERRED_WIDTH = 260;

    public ValidClassesPanel(DefaultExplorerFilter filter) {
        this.filter = filter;
        this.list = new JList<ListItem>(new ListItem[]{new ListItem(RDFSNamedClass.class, "Named classes", "PrimitiveClass"), new ListItem(OWLAllValuesFrom.class, "AllValuesFrom restrictions", "OWLAllValuesFrom"), new ListItem(OWLSomeValuesFrom.class, "SomeValuesFrom restrictions", "OWLSomeValuesFrom"), new ListItem(OWLHasValue.class, "HasValue restrictions", "OWLHasValue"), new ListItem(OWLCardinality.class, "Cardinality restrictions", "OWLCardinality"), new ListItem(OWLMinCardinality.class, "MinCardinality restrictions", "OWLMinCardinality"), new ListItem(OWLMaxCardinality.class, "MaxCardinality restrictions", "OWLMaxCardinality"), new ListItem(OWLIntersectionClass.class, "Intersection classes", "OWLIntersectionClass"), new ListItem(OWLUnionClass.class, "Union classes", "OWLUnionClass"), new ListItem(OWLComplementClass.class, "Complement classes", "OWLComplementClass"), new ListItem(OWLEnumeratedClass.class, "Enumerated classes", "OWLEnumeratedClass")});
        this.list.setCellRenderer(new DefaultRenderer(){

            public void load(Object o) {
                ListItem item = (ListItem)o;
                this.setMainIcon(item.icon);
                this.setMainText(item.name);
            }
        });
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ValidClassesPanel.this.updateFilter();
            }
        });
        this.updateListSelection();
        OWLLabeledComponent lc = new OWLLabeledComponent("Show only Classes of Types", new JScrollPane(this.list));
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)lc));
        this.setPreferredSize(new Dimension(260, 260));
    }

    private int getListIndex(Class c) {
        int i = 0;
        while (i < this.list.getModel().getSize()) {
            ListItem listItem = (ListItem)this.list.getModel().getElementAt(i);
            if (listItem.type == c) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateFilter() {
        this.filter.removeAllValidClasses();
        int[] sels = this.list.getSelectedIndices();
        int i = 0;
        while (i < sels.length) {
            ListItem listItem = (ListItem)this.list.getModel().getElementAt(sels[i]);
            this.filter.addValidClass(listItem.type);
            ++i;
        }
    }

    private void updateListSelection() {
        ListSelectionModel selectionModel = this.list.getSelectionModel();
        selectionModel.clearSelection();
        for (Class c : this.filter.getValidClasses()) {
            int index = this.getListIndex(c);
            selectionModel.addSelectionInterval(index, index);
        }
    }

    private class ListItem {
        Class type;
        Icon icon;
        String name;

        ListItem(Class type, String name, String iconName) {
            this.type = type;
            this.icon = OWLIcons.getImageIcon(iconName);
            this.name = name;
        }
    }
}

