/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.imports;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.model.util.ImportHelper;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTreePanel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.ImportsTableModel;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.emptyimport.EmptyImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.AddedPrefixesTable;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportEntry;
import edu.stanford.smi.protegex.owl.ui.metadatatab.imports.wizard.ImportWizard;
import edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes.PrefixesPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImportsPanel
extends JPanel
implements Disposable {
    private Action addImportAction = new AbstractAction("Import ontology...", OWLIcons.getAddIcon("Import")){

        public void actionPerformed(ActionEvent e) {
            ImportsPanel.this.addImport();
        }
    };
    private Action createImportedTripleStoreAction = new AbstractAction("Create empty imported ontology...", OWLIcons.getCreateIcon("Import")){

        public void actionPerformed(ActionEvent e) {
            ImportsPanel.this.createImportedTripleStore();
        }
    };
    private Action showImportsTreeAction = new AbstractAction("Show imports tree", OWLIcons.getImageIcon("View")){

        public void actionPerformed(ActionEvent e) {
            ImportsTreePanel.showDialog(ImportsPanel.this.owlModel);
        }
    };
    private OWLModel owlModel;
    private PrefixesPanel prefixesPanel;
    private Action removeAction = new AbstractAction("Remove import", OWLIcons.getRemoveIcon("Import")){

        public void actionPerformed(ActionEvent e) {
            ImportsPanel.this.removeSelectedImport();
        }
    };
    private JTable table;
    private ImportsTableModel tableModel;

    public ImportsPanel(OWLOntology ontology) {
        this.owlModel = ontology.getOWLModel();
        this.tableModel = new ImportsTableModel(ontology);
        this.table = new JTable(this.tableModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.setLayout(new BorderLayout(0, 10));
        JScrollPane scrollPane = new JScrollPane(this.table);
        OWLLabeledComponent lc = new OWLLabeledComponent("Imports", scrollPane);
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        lc.addHeaderButton(this.createImportedTripleStoreAction);
        lc.addHeaderButton(this.addImportAction);
        lc.addHeaderButton(this.showImportsTreeAction);
        lc.addHeaderButton(this.removeAction);
        this.removeAction.setEnabled(false);
        this.add("Center", (Component)((Object)lc));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ImportsPanel.this.enableActions();
                ImportsPanel.this.synchronizePrefixesPanel();
            }
        });
    }

    private void addImport() {
        try {
            ImportWizard wizard = new ImportWizard((JComponent)this, this.owlModel);
            if (wizard.execute() == 1) {
                ImportHelper importHelper = new ImportHelper((JenaOWLModel)this.owlModel);
                ArrayList prefixes = new ArrayList(this.owlModel.getNamespaceManager().getPrefixes());
                for (ImportEntry importEntry : wizard.getImportData().getImportEntries()) {
                    Repository rep = importEntry.getRepositoryToAdd();
                    if (rep != null) {
                        this.owlModel.getRepositoryManager().addProjectRepository(importEntry.getRepository());
                    }
                    URI ontologyURI = importEntry.getOntologyURI();
                    importHelper.addImport(ontologyURI);
                }
                importHelper.importOntologies();
                ArrayList addedPrefixes = new ArrayList(this.owlModel.getNamespaceManager().getPrefixes());
                addedPrefixes.removeAll(prefixes);
                if (addedPrefixes.size() > 0) {
                    Component topLevelContainer = ProtegeUI.getTopLevelContainer(this.owlModel.getProject());
                    AddedPrefixesTable.showDialog(topLevelContainer, this.owlModel, addedPrefixes);
                }
            }
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    private void createImportedTripleStore() {
        EmptyImportWizard wizard = new EmptyImportWizard((JComponent)this, this.owlModel);
        wizard.execute();
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    private void enableActions() {
        boolean rowSelected = this.table.getSelectedRow() >= 0 && this.table.getSelectedRow() < this.tableModel.getRowCount();
        this.removeAction.setEnabled(rowSelected);
    }

    private void removeSelectedImport() {
        int sel = this.table.getSelectedRow();
        if (sel >= 0 && sel < this.tableModel.getRowCount() && OWLUtil.confirmSaveAndReload(this.owlModel.getProject())) {
            this.tableModel.deleteRow(sel);
            OWLUtil.saveAndReloadProject();
        }
    }

    public void setPrefixesPanel(PrefixesPanel prefixesPanel) {
        this.prefixesPanel = prefixesPanel;
    }

    public void setSelectedNamespace(String namespace) {
        int row;
        String uri = namespace;
        if (Jena.isNamespaceWithSeparator(namespace)) {
            uri = namespace.substring(0, namespace.length() - 1);
        }
        if ((row = this.tableModel.getURIRow(uri)) >= 0) {
            this.table.getSelectionModel().setSelectionInterval(row, row);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
    }

    private void synchronizePrefixesPanel() {
        int sel;
        if (this.prefixesPanel != null && (sel = this.table.getSelectedRow()) >= 0 && sel < this.tableModel.getRowCount()) {
            String uri = this.tableModel.getURI(sel);
            this.prefixesPanel.setSelectedURI(uri);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.table.setEnabled(enabled);
        this.addImportAction.setEnabled(enabled);
        this.createImportedTripleStoreAction.setEnabled(enabled);
        this.showImportsTreeAction.setEnabled(enabled);
        this.removeAction.setEnabled(enabled);
    }
}

