/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ClassAdapter;
import edu.stanford.smi.protegex.owl.model.event.ClassListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractOWLTableModel
extends AbstractTableModel
implements OWLTableModel {
    private OWLNamedClass cls;
    private int expressionColumn;
    private List rows = new ArrayList();
    private ClassListener classListener = new ClassAdapter(){

        public void subclassAdded(RDFSClass cls, RDFSClass subclass) {
            AbstractOWLTableModel.this.refill();
        }

        public void subclassRemoved(RDFSClass cls, RDFSClass subclass) {
            AbstractOWLTableModel.this.refill();
        }

        public void superclassAdded(RDFSClass cls, RDFSClass superclass) {
            AbstractOWLTableModel.this.refill();
        }

        public void superclassRemoved(RDFSClass cls, RDFSClass superclass) {
            AbstractOWLTableModel.this.refill();
        }
    };

    protected AbstractOWLTableModel(int expressionColumn) {
        this.expressionColumn = expressionColumn;
    }

    public int addEmptyRow(int rowIndex) {
        int index = this.getRowCount();
        this.rows.add(null);
        this.fireTableRowsInserted(index, index);
        return index;
    }

    protected void addRows() {
        Collection superClasses = this.cls.getSuperclasses(true);
        for (Cls superCls : superClasses) {
            if (!this.isSuitable(superCls)) continue;
            this.insertRow(superCls);
        }
    }

    void clearRows() {
        int count = this.getRowCount();
        this.rows.clear();
        if (count > 0) {
            this.fireTableRowsDeleted(0, count - 1);
        }
    }

    public void deleteRow(int index) {
        RDFSClass superCls = (RDFSClass)this.rows.get(index);
        OWLModel kb = this.cls.getOWLModel();
        if (this.cls.getNamedSuperclasses().size() == 1 && superCls instanceof OWLNamedClass) {
            this.cls.addSuperclass(kb.getOWLThingClass());
        }
        this.cls.removeSuperclass(superCls);
        this.fireTableRowsDeleted(index, index);
    }

    public void displaySemanticError(String message) {
        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.cls.getOWLModel(), message, "Semantic Error");
    }

    public void dispose() {
        if (this.cls != null) {
            this.removeListeners();
        }
    }

    Cls getCls() {
        return this.cls;
    }

    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int column) {
        return "Expression";
    }

    public RDFSClass getClass(int rowIndex) {
        return (RDFSClass)this.rows.get(rowIndex);
    }

    public int getClassRow(RDFSClass superCls) {
        return this.rows.indexOf(superCls);
    }

    public OWLNamedClass getEditedCls() {
        return this.cls;
    }

    public RDFResource getRDFResource(int row) {
        return this.getClass(row);
    }

    public RDFResource getSubject() {
        return this.cls;
    }

    public int getSymbolColumnIndex() {
        return this.expressionColumn;
    }

    public Icon getIcon(RDFResource resource) {
        return ProtegeUI.getIcon(resource);
    }

    public boolean isAddEnabledAt(int rowIndex) {
        return this.isEditable();
    }

    public boolean isEditable() {
        return this.getEditedCls().isEditable();
    }

    protected abstract int getInsertRowIndex(Cls var1);

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rows.get(rowIndex) == null) {
            return "";
        }
        RDFSClass superCls = this.getClass(rowIndex);
        return superCls.getBrowserText();
    }

    protected void insertRow(Cls cls) {
        if (this.isSuitable(cls)) {
            int index = this.getInsertRowIndex(cls);
            this.rows.add(index, cls);
            this.fireTableRowsInserted(index, index);
        }
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == this.expressionColumn;
    }

    protected abstract boolean isSuitable(Cls var1);

    public void refill() {
        this.clearRows();
        this.addRows();
    }

    public void removeEmptyRow() {
        int rowIndex = this.rows.indexOf(null);
        if (rowIndex >= 0) {
            this.rows.remove(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }
    }

    private void removeListeners() {
        this.cls.removeClassListener(this.classListener);
    }

    public void setCls(OWLNamedClass newCls) {
        this.clearRows();
        if (this.cls != null) {
            this.removeListeners();
        }
        this.cls = newCls;
        if (this.cls != null) {
            this.cls.addClassListener(this.classListener);
            this.addRows();
        }
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        if (rowIndex >= this.getRowCount()) {
            return;
        }
        if (columnIndex == this.expressionColumn) {
            String text = (String)value;
            try {
                this.setValueAt(rowIndex, this.cls.getOWLModel(), text);
            }
            catch (Exception ex) {
                Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            }
        }
    }

    protected abstract void setValueAt(int var1, OWLModel var2, String var3) throws Exception;
}

