/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.owltable;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.owltable.AbstractOWLTableAction;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTable;
import edu.stanford.smi.protegex.owl.ui.owltable.OWLTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class DeleteRowAction
extends AbstractOWLTableAction {
    private OWLTable table;

    public DeleteRowAction(OWLTable table) {
        super("Delete selected row", OWLIcons.getDeleteIcon("OWLAnonymousClass"));
        this.table = table;
    }

    public void actionPerformed(ActionEvent e) {
        OWLTableModel tableModel;
        OWLClassesTab tab = OWLClassesTab.getOWLClassesTab((Component)((Object)this.table));
        OWLNamedClass editedClass = this.table.getEditedCls();
        int selIndex = this.table.getSelectedRow();
        if (selIndex >= 0 && (tableModel = (OWLTableModel)this.table.getModel()).isCellEditable(selIndex, tableModel.getSymbolColumnIndex())) {
            tableModel.deleteRow(selIndex);
            this.table.getSelectionModel().setSelectionInterval(selIndex, selIndex);
            if (tab != null) {
                tab.ensureClassSelected(editedClass, -1);
            }
        }
    }

    public boolean isEnabledFor(RDFSClass cls, int rowIndex) {
        OWLTableModel tableModel = (OWLTableModel)this.table.getModel();
        return cls != null && tableModel.isDeleteEnabledFor(cls);
    }
}

