/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.profiles;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.RDFS;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.icons.OverlayIcon;
import edu.stanford.smi.protegex.owl.ui.profiles.EditProfilePanel;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class ProfileSelectionPanel
extends JPanel {
    private boolean changed = false;
    private Action createFileAction = new AbstractAction("Create new profile file...", OWLIcons.getCreateIcon("File")){

        public void actionPerformed(ActionEvent e) {
            ProfileSelectionPanel.this.createFile();
        }
    };
    private JRadioButton customRadioButton;
    private JTextField customTextField;
    private OntModel defaultOntModel;
    private JRadioButton defaultRadioButton;
    public static final String[] DEFAULT_PROFILES = new String[]{OWLProfiles.RDF.getURI(), OWLProfiles.RDF_but_not_OWL.getURI(), OWLProfiles.OWL_Full.getURI(), OWLProfiles.OWL_DL.getURI(), OWLProfiles.OWL_Lite.getURI()};
    private Action editProfileAction = new AbstractAction("Edit profile...", OWLIcons.getImageIcon("EditProfile")){

        public void actionPerformed(ActionEvent e) {
            ProfileSelectionPanel.this.editProfile();
        }
    };
    private static JFileChooser fileChooser;
    private String oldProfileURI;
    private OWLModel owlModel;
    private JComboBox predefinedProfileComboBox;
    private Action selectFileAction = new AbstractAction("Select file...", OWLIcons.getAddIcon("File")){

        public void actionPerformed(ActionEvent e) {
            ProfileSelectionPanel.this.selectFile();
        }
    };

    public ProfileSelectionPanel(OWLModel owlModel) {
        this.oldProfileURI = ProfilesManager.getProfile(owlModel);
        this.defaultOntModel = ProfilesManager.getDefaultProfileOntModel();
        if (this.defaultOntModel == null) {
            return;
        }
        this.owlModel = owlModel;
        this.predefinedProfileComboBox = this.createComboBox(owlModel);
        this.defaultRadioButton = new JRadioButton("Use standard profile:");
        this.defaultRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfileSelectionPanel.this.updateComponents(true);
            }
        });
        this.customRadioButton = new JRadioButton("Use custom profile:");
        this.customRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfileSelectionPanel.this.updateComponents(false);
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.customRadioButton);
        group.add(this.defaultRadioButton);
        this.setBorder(BorderFactory.createTitledBorder("Language Profile"));
        JPanel defaultPanel = new JPanel(new FlowLayout());
        defaultPanel.add(this.defaultRadioButton);
        defaultPanel.add(this.predefinedProfileComboBox);
        this.customTextField = new JTextField();
        String custom = ProfilesManager.getCustomProfileURI(owlModel);
        if (custom != null) {
            this.customTextField.setText(custom);
        }
        this.customTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ProfileSelectionPanel.this.assignCustomTextFieldValue();
            }
        });
        JPanel customPanel = new JPanel(new FlowLayout());
        customPanel.add(this.customRadioButton);
        customPanel.add(this.customTextField);
        this.customTextField.setPreferredSize(new Dimension(300, this.customTextField.getPreferredSize().height));
        JToolBar customToolBar = ComponentFactory.createToolBar();
        this.addToolBarButton(customToolBar, this.createFileAction);
        this.addToolBarButton(customToolBar, this.selectFileAction);
        this.addToolBarButton(customToolBar, this.editProfileAction);
        customPanel.add(customToolBar);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.createLeftAlignedPanel(defaultPanel));
        this.add(this.createLeftAlignedPanel(customPanel));
        this.updateComponents(ProfilesManager.getCustomProfileURI(owlModel) == null);
    }

    private void assignCustomTextFieldValue() {
        String value = this.customTextField.getText().trim();
        String newProfile = null;
        newProfile = value.length() == 0 ? ProfilesManager.getPredefinedProfile(this.owlModel) : value;
        ProfilesManager.setProfile(this.owlModel, newProfile);
    }

    private void addToolBarButton(JToolBar toolBar, Action action) {
        JButton button = ComponentFactory.addToolBarButton((JToolBar)toolBar, (Action)action);
        Icon icon = (Icon)action.getValue("SmallIcon");
        if (icon instanceof OverlayIcon) {
            button.setDisabledIcon(((OverlayIcon)icon).getGrayedIcon());
        }
    }

    private JComboBox createComboBox(final OWLModel owlModel) {
        final OntClass[] items = new OntClass[DEFAULT_PROFILES.length];
        int i = 0;
        while (i < items.length) {
            items[i] = this.defaultOntModel.getOntClass(DEFAULT_PROFILES[i]);
            ++i;
        }
        final JComboBox<OntClass> comboBox = new JComboBox<OntClass>(items);
        String predefinedURI = ProfilesManager.getPredefinedProfile(owlModel);
        int i2 = 0;
        while (!predefinedURI.equals(items[i2].getURI())) {
            ++i2;
        }
        comboBox.setSelectedIndex(i2);
        comboBox.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                OntClass ontClass = (OntClass)value;
                String label = ontClass.getLabel("");
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProfilesManager.setProfile(owlModel, items[comboBox.getSelectedIndex()].getURI());
                owlModel.setOWLTestGroupEnabled("OWL-DL Tests", ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.OWL_DL));
            }
        });
        return comboBox;
    }

    private void createFile() {
        String baseFileName = "MyProfile";
        String suffix = ".owl";
        String fileName = String.valueOf(baseFileName) + suffix;
        int i = 1;
        while (new File(fileName).exists()) {
            fileName = String.valueOf(baseFileName) + "_" + i + suffix;
            ++i;
        }
        String predefined = ProfilesManager.getPredefinedProfile(this.owlModel);
        String ns = "http://www.owl-ontologies.com/" + fileName + "#";
        OntModel ontModel = ProfilesManager.createProfile(ns);
        OntClass ontClass = ontModel.createClass(String.valueOf(ns) + "MyProfile");
        Resource predefinedClass = ontModel.getResource(predefined);
        ontModel.add(predefinedClass, RDFS.subClassOf, (RDFNode)ontClass);
        try {
            ProfilesManager.saveOntModel(ontModel, fileName);
            this.customTextField.setText(fileName);
            this.changed = true;
            ProfilesManager.setProfile(this.owlModel, fileName);
            ProfilesManager.clearCache(fileName);
            OntModel newOntModel = ProfilesManager.getProfileOntModel(this.owlModel);
            if (EditProfilePanel.showProfilePanelDialog(this.owlModel, newOntModel, fileName)) {
                this.customTextField.setText(ProfilesManager.getCustomProfileURI(this.owlModel));
            }
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            OWLUI.showErrorMessageDialog("Could not create profile file " + fileName + ":\n" + ex, "Error");
        }
    }

    private JPanel createLeftAlignedPanel(Component comp) {
        JPanel result = new JPanel(new BorderLayout());
        result.add("West", comp);
        result.add("Center", new JPanel());
        return result;
    }

    private void editProfile() {
        if (ProfilesManager.getCustomProfileURI(this.owlModel) != null) {
            if (EditProfilePanel.showProfilePanelDialog(this.owlModel)) {
                this.customTextField.setText(ProfilesManager.getCustomProfileURI(this.owlModel));
                this.changed = true;
            }
        } else {
            this.createFile();
        }
    }

    public boolean getRequiresReloadUI() {
        return !this.oldProfileURI.equals(ProfilesManager.getProfile(this.owlModel)) || this.changed;
    }

    private void selectFile() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(".");
        }
        if (fileChooser.showOpenDialog(this) == 0) {
            File file = fileChooser.getSelectedFile();
            this.customTextField.setText(file.getAbsolutePath());
        }
    }

    private void updateComponents(boolean defaultEnabled) {
        this.defaultRadioButton.setSelected(defaultEnabled);
        this.predefinedProfileComboBox.setEnabled(defaultEnabled);
        this.customRadioButton.setSelected(!defaultEnabled);
        this.customTextField.setEnabled(!defaultEnabled);
        this.selectFileAction.setEnabled(!defaultEnabled);
        this.createFileAction.setEnabled(!defaultEnabled);
        this.editProfileAction.setEnabled(!defaultEnabled);
    }
}

