/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.navigation.NavigationHistoryTabWidget;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertyHierarchiesPanel;
import edu.stanford.smi.protegex.owl.ui.resourcedisplay.ResourcePanel;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractTabWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class OWLPropertiesTab
extends AbstractTabWidget
implements NavigationHistoryTabWidget {
    private ResourcePanel resourcePanel;
    private OWLPropertyHierarchiesPanel owlHierarchiesPanel;

    private JComponent createMainSplitter() {
        JSplitPane mainSplitter = this.createLeftRightSplitPane("SlotsTab.left_right", 250);
        this.owlHierarchiesPanel = new OWLPropertyHierarchiesPanel(this.getOWLModel());
        mainSplitter.setLeftComponent(this.owlHierarchiesPanel);
        this.owlHierarchiesPanel.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                OWLPropertiesTab.this.transmitSelection();
            }
        });
        this.resourcePanel = this.createResourcePanel();
        JPanel resourceDisplayHolder = new JPanel(new BorderLayout());
        resourceDisplayHolder.add("Center", (Component)((Object)this.resourcePanel));
        mainSplitter.setRightComponent(resourceDisplayHolder);
        return mainSplitter;
    }

    protected ResourcePanel createResourcePanel() {
        return ProtegeUI.getResourcePanelFactory().createResourcePanel(this.getOWLModel(), 1);
    }

    public boolean displayHostResource(RDFResource resource) {
        return this.owlHierarchiesPanel.displayHostResource(resource);
    }

    public Selectable getNestedSelectable() {
        return this.owlHierarchiesPanel;
    }

    public void initialize() {
        this.setIcon(OWLIcons.getPropertiesIcon());
        this.setLabel("Properties");
        this.add(this.createMainSplitter());
        if (!this.owlHierarchiesPanel.getSelection().isEmpty()) {
            this.transmitSelection();
        }
    }

    public static boolean isSuitable(Project p, Collection errors) {
        return OWLClassesTab.isSuitable(p, errors);
    }

    public void setSelectedProperty(RDFProperty property) {
    }

    public void setSelectedSlot(OWLProperty property) {
        this.setSelectedProperty(property);
    }

    private void transmitSelection() {
        RDFProperty selection = (RDFProperty)CollectionUtilities.getFirstItem((Collection)this.owlHierarchiesPanel.getSelection());
        this.resourcePanel.setResource(selection);
    }
}

