/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties;

import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.ui.SlotSubslotNode;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.event.PropertyAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyListener;
import edu.stanford.smi.protegex.owl.model.event.ResourceAdapter;
import edu.stanford.smi.protegex.owl.model.event.ResourceListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class OWLPropertySubpropertyRoot
extends LazyTreeRoot {
    private OWLModel owlModel;
    private ModelListener modelListener = new ModelAdapter(){

        public void propertyCreated(RDFProperty property) {
            if (property.getSuperproperties(false).isEmpty() && OWLPropertySubpropertyRoot.this.isSuitable(property)) {
                List properties = (List)OWLPropertySubpropertyRoot.this.getUserObject();
                int index = 0;
                if (index < 0) {
                    index = -(index + 1);
                }
                properties.add(index, property);
                OWLPropertySubpropertyRoot.this.childAdded(property, index);
                if (OWLPropertySubpropertyRoot.this.getChildCount() == 1) {
                    OWLPropertySubpropertyRoot.this.notifyNodeStructureChanged((LazyTreeNode)OWLPropertySubpropertyRoot.this);
                }
            }
        }

        public void propertyDeleted(RDFProperty property) {
            List properties = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            boolean changed = properties.remove(property);
            if (changed) {
                OWLPropertySubpropertyRoot.this.childRemoved(property);
            }
        }
    };
    public PropertyListener propertyListener = new PropertyAdapter(){

        public void superpropertyAdded(RDFProperty property, RDFProperty superproperty) {
            if (property.getSuperpropertyCount() == 1 && OWLPropertySubpropertyRoot.this.isSuitable(property)) {
                this.removeChild(property);
            }
        }

        public void superpropertyRemoved(RDFProperty property, RDFProperty superproperty) {
            if (property.getSuperpropertyCount() == 0 && OWLPropertySubpropertyRoot.this.isSuitable(property)) {
                this.addChild(property);
            }
        }

        private void removeChild(Slot slot) {
            List slots = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            slots.remove(slot);
            OWLPropertySubpropertyRoot.this.childRemoved(slot);
        }

        private void addChild(Slot slot) {
            List slots = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            slots.add(slot);
            OWLPropertySubpropertyRoot.this.childAdded(slot);
        }
    };
    public ResourceListener resourceListener = new ResourceAdapter(){

        public void typeAdded(RDFResource resource, RDFSClass type) {
            if (resource instanceof RDFProperty) {
                this.addChild((RDFProperty)resource);
                this.removeChild((RDFProperty)resource);
            }
        }

        public void typeRemoved(RDFResource resource, RDFSClass type) {
            if (resource instanceof RDFProperty) {
                this.removeChild((RDFProperty)resource);
                this.addChild((RDFProperty)resource);
            }
        }

        private void removeChild(RDFProperty slot) {
            List slots = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            if (slots.contains(slot) && !OWLPropertySubpropertyRoot.this.isSuitable(slot)) {
                slots.remove(slot);
                OWLPropertySubpropertyRoot.this.childRemoved(slot);
            }
        }

        private void addChild(RDFProperty slot) {
            List slots = (List)OWLPropertySubpropertyRoot.this.getUserObject();
            if (!slots.contains(slot) && slot.getSuperpropertyCount() == 0 && OWLPropertySubpropertyRoot.this.isSuitable(slot)) {
                slots.add(slot);
                OWLPropertySubpropertyRoot.this.childAdded(slot);
            }
        }
    };

    public OWLPropertySubpropertyRoot(OWLModel owlModel, Collection topLevelProperties) {
        super(topLevelProperties);
        this.owlModel = owlModel;
        this.owlModel.addModelListener(this.modelListener);
        this.owlModel.addPropertyListener(this.propertyListener);
        this.owlModel.addResourceListener(this.resourceListener);
    }

    public boolean isSuitable(RDFProperty rdfProperty) {
        return true;
    }

    public OWLPropertySubpropertyRoot(OWLModel owlModel) {
        super(OWLPropertySubpropertyRoot.getValidSlots(owlModel));
        owlModel.addModelListener(this.modelListener);
        owlModel.addPropertyListener(this.propertyListener);
        owlModel.addResourceListener(this.resourceListener);
        this.owlModel = owlModel;
    }

    public LazyTreeNode createNode(Object o) {
        return new SlotSubslotNode((LazyTreeNode)this, (Slot)o);
    }

    public void dispose() {
        super.dispose();
        this.owlModel.removeModelListener(this.modelListener);
        this.owlModel.removePropertyListener(this.propertyListener);
    }

    public Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    private static Collection getValidSlots(OWLModel owlModel) {
        ArrayList results = new ArrayList(owlModel.getVisibleUserDefinedRDFProperties());
        Iterator i = results.iterator();
        while (i.hasNext()) {
            Slot slot = (Slot)i.next();
            if (slot.getDirectSuperslotCount() <= 0) continue;
            i.remove();
        }
        results.remove(owlModel.getRDFProperty(":FROM"));
        results.remove(owlModel.getRDFProperty(":TO"));
        results.removeAll((Collection)Arrays.asList(owlModel.getSystemAnnotationProperties()));
        Collections.sort(results, new FrameComparator());
        return results;
    }
}

