/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.query;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.query.QueryResults;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.query.FindAssertionsAction;
import edu.stanford.smi.protegex.owl.ui.query.SPARQLQueryPanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SPARQLResultsPanel
extends ResultsPanel {
    private OWLModel owlModel;
    private SPARQLQueryPanel queryPanel;
    private JSplitPane splitPane;
    private JTable table;
    private Action toggleLayoutAction = new AbstractAction("Toggle layout", OWLIcons.getImageIcon("LayoutVertically")){

        public void actionPerformed(ActionEvent e) {
            if (SPARQLResultsPanel.this.splitPane.getOrientation() == 0) {
                SPARQLResultsPanel.this.splitPane.setOrientation(1);
                SPARQLResultsPanel.this.toggleLayoutAction.putValue("SmallIcon", OWLIcons.getImageIcon("LayoutVertically"));
            } else {
                SPARQLResultsPanel.this.splitPane.setOrientation(0);
                SPARQLResultsPanel.this.toggleLayoutAction.putValue("SmallIcon", OWLIcons.getImageIcon("LayoutHorizontally"));
            }
            SPARQLResultsPanel.this.repaint();
        }
    };
    public static final String NAME = "SPARQL";

    public SPARQLResultsPanel(OWLModel owlModel, boolean withQueryArea) {
        super(owlModel);
        this.owlModel = owlModel;
        this.table = new JTable(new DefaultTableModel());
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    SPARQLResultsPanel.this.handleDoubleClick();
                }
            }
        });
        this.table.setCellSelectionEnabled(true);
        JScrollPane sp = new JScrollPane(this.table);
        sp.getViewport().setBackground(Color.white);
        OWLLabeledComponent lc = new OWLLabeledComponent("Results", sp);
        if (withQueryArea) {
            this.queryPanel = new SPARQLQueryPanel(owlModel);
            this.splitPane = new JSplitPane(1, this.queryPanel, (Component)((Object)lc));
            this.add("Center", this.splitPane);
            this.addButton(this.toggleLayoutAction);
            this.addButton(new FindAssertionsAction(owlModel));
        } else {
            this.add("Center", (Component)((Object)lc));
        }
    }

    private TableModel createTableModel(QueryResults results) {
        DefaultTableModel tableModel = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        List vars = results.getVariables();
        int i = 0;
        while (i < vars.size()) {
            String varName = (String)vars.get(i);
            tableModel.addColumn(varName);
            ++i;
        }
        while (results.hasNext()) {
            Map map = results.next();
            Object[] data = new Object[vars.size()];
            int i2 = 0;
            while (i2 < vars.size()) {
                String varName = (String)vars.get(i2);
                RDFObject value = (RDFObject)map.get(varName);
                data[i2] = value;
                ++i2;
            }
            tableModel.addRow(data);
        }
        return tableModel;
    }

    public void dispose() {
        if (this.queryPanel != null) {
            this.queryPanel.rememberQueryText();
        }
    }

    public void executeQuery(String queryText) {
        try {
            QueryResults results = this.owlModel.executeSPARQLQuery(queryText);
            if (results.hasNext()) {
                TableModel tableModel = this.createTableModel(results);
                this.table.setModel(tableModel);
                int i = 0;
                while (i < tableModel.getColumnCount()) {
                    TableColumn col = this.table.getColumnModel().getColumn(i);
                    col.setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
                    ++i;
                }
            } else {
                this.table.setModel(new DefaultTableModel());
                ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "No matches found.");
            }
        }
        catch (Exception ex) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", ex);
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(this.owlModel, "Query failed:\n" + ex.getMessage());
        }
    }

    public Icon getIcon() {
        return OWLIcons.getImageIcon("SPARQLResultsPanel");
    }

    public String getTabName() {
        return NAME;
    }

    private void handleDoubleClick() {
        int[] sels = this.table.getSelectedRows();
        if (sels.length == 1) {
            Object sel;
            int row = sels[0];
            int col = this.table.getSelectedColumn();
            if (col >= 0 && col < this.table.getModel().getColumnCount() && (sel = this.table.getModel().getValueAt(row, col)) instanceof RDFResource) {
                RDFResource resource = (RDFResource)sel;
                this.showHostResource(resource);
            }
        }
    }

    public void setQueryText(String str) {
        this.queryPanel.setQueryText(str);
    }
}

