/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableItem;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableModelColumns;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

public class FindUsageTableModel
extends AbstractTableModel
implements Disposable,
FindUsageTableModelColumns {
    private List items;
    private OWLModel owlModel;
    private ModelListener listener = new ModelAdapter(){

        public void classDeleted(RDFSClass cls) {
            FindUsageTableModel.this.deleteItemsWith((Frame)cls);
        }

        public void individualDeleted(RDFResource resource) {
            FindUsageTableModel.this.deleteItemsWith((Frame)resource);
        }

        public void propertyDeleted(RDFProperty property) {
            FindUsageTableModel.this.deleteItemsWith((Frame)property);
        }
    };
    private int sortColumn = 0;

    public FindUsageTableModel(OWLModel owlModel, Collection items) {
        this.items = new ArrayList(items);
        this.owlModel = owlModel;
        this.sort();
        owlModel.addModelListener(this.listener);
    }

    private void deleteItemsWith(Frame cls) {
        int i = this.items.size() - 1;
        while (i >= 0) {
            FindUsageTableItem item = this.getItem(i);
            if (item.contains(cls)) {
                this.items.remove(i);
                this.fireTableRowsDeleted(i, i);
            }
            --i;
        }
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.listener);
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return RDFResource.class;
        }
        if (column == 2) {
            return RDFResource.class;
        }
        if (column == 1) {
            return Icon.class;
        }
        return null;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int column) {
        String str = "";
        if (column == 0) {
            str = "Resource";
        } else if (column == 2) {
            str = "Expression";
        } else if (column == 1) {
            str = "Type";
        }
        if (str != null && column == this.sortColumn) {
            str = "[" + str + "]";
        }
        return str;
    }

    RDFResource getHost(int row) {
        return this.getItem((int)row).host;
    }

    private FindUsageTableItem getItem(int row) {
        return (FindUsageTableItem)this.items.get(row);
    }

    public int getRowCount() {
        return this.items.size();
    }

    public RDFResource getUsage(int rowIndex) {
        return (RDFResource)this.getValueAt(rowIndex, 2);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            return this.getItem((int)rowIndex).usage;
        }
        if (columnIndex == 0) {
            return this.getHost(rowIndex);
        }
        if (columnIndex == 1) {
            return this.getItem(rowIndex).getIcon();
        }
        return null;
    }

    public void setItems(Collection items) {
        this.items = new ArrayList(items);
        this.fireTableDataChanged();
    }

    public void setSortColumn(int column) {
        this.sortColumn = column;
        this.sort();
        this.fireTableStructureChanged();
    }

    private void sort() {
        Collections.sort(this.items, new Comparator(){

            public int compare(Object o1, Object o2) {
                FindUsageTableItem item1 = (FindUsageTableItem)o1;
                FindUsageTableItem item2 = (FindUsageTableItem)o2;
                if (FindUsageTableModel.this.sortColumn == 0) {
                    return item1.host.getBrowserText().compareTo(item2.host.getBrowserText());
                }
                if (FindUsageTableModel.this.sortColumn == 1) {
                    return new Integer(item1.type).compareTo(new Integer(item2.type));
                }
                if (FindUsageTableModel.this.sortColumn == 2) {
                    return item1.usage.getBrowserText().compareTo(item2.usage.getBrowserText());
                }
                return 0;
            }
        });
    }
}

