/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protegex.owl.ui.results.HostResourceDisplay;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindResultsView;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindAction;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResultsListView;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResultsTableView;
import edu.stanford.smi.protegex.owl.ui.search.finder.ResultsViewModelFind;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.text.JTextComponent;

abstract class AbstractFindAction
extends AbstractAction
implements FindAction {
    private JTextComponent searchBox;
    protected ResultsViewModelFind find;
    protected boolean allowSave;
    private HostResourceDisplay hrd;

    public AbstractFindAction(ResultsViewModelFind find, Icon icon) {
        this(find, icon, null);
    }

    public AbstractFindAction(ResultsViewModelFind find, Icon icon, HostResourceDisplay hrd) {
        this(find, icon, hrd, false);
    }

    public AbstractFindAction(ResultsViewModelFind find, Icon icon, HostResourceDisplay hrd, boolean allowSave) {
        super(find.getDescription(), icon);
        this.find = find;
        this.hrd = hrd;
        this.allowSave = allowSave;
    }

    public void setTextBox(JTextComponent textBox) {
        this.searchBox = textBox;
    }

    public void actionPerformed(ActionEvent e) {
        String txt = "";
        if (this.searchBox != null) {
            txt = this.searchBox.getText();
        }
        this.find.startSearch(txt);
        if (this.find.getNumSearchProperties() > 1) {
            this.showResults(new FindResultsTableView(this.find, this.hrd));
        } else {
            this.showResults(new FindResultsListView(this.find, this.hrd));
        }
    }

    protected abstract void showResults(AbstractFindResultsView var1);
}

