/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindResultsView;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.RetainFindResultsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FindResultsPanel
extends JComponent {
    private static final String SEARCH_AS_YOU_TYPE_LABEL = "Search as you type";
    private static final String SEARCH_PATTERN_LABEL = "Search Pattern";
    private static final String SAVE_RESULTS_LABEL = "Save Results";
    private Find find;
    private JButton saveResultButton;
    private JComboBox searchTypeCombo;
    private JTextField textField;
    private JCheckBox searchAsYouTypeCheckbox;
    private JPanel mainPanel;
    private AbstractFindResultsView view;
    private static boolean searchAsYouType = true;
    private DocumentListener searchAsYouTypeListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            FindResultsPanel.this.refresh();
        }

        public void removeUpdate(DocumentEvent e) {
            FindResultsPanel.this.refresh();
        }

        public void changedUpdate(DocumentEvent e) {
            FindResultsPanel.this.refresh();
        }
    };
    private Action saveResultsAction = new AbstractAction("Save Results", Icons.getDownIcon()){

        public void actionPerformed(ActionEvent e) {
            FindResultsPanel.this.view.requestDispose();
            FindResultsPanel.this.setSaveResultsEnabled(false);
            RetainFindResultsPanel resultsPanel = new RetainFindResultsPanel(FindResultsPanel.this.find.getModel(), FindResultsPanel.this);
            ResultsPanelManager.addResultsPanel(FindResultsPanel.this.find.getModel(), resultsPanel, true);
        }
    };

    public FindResultsPanel(Find find, AbstractFindResultsView view) {
        this.setLayout(new BorderLayout());
        this.find = find;
        this.view = view;
        this.textField = this.createTextField();
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent e) {
                FindResultsPanel.this.requestFocus();
            }
        });
        view.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FindResultsPanel.this.selectResource();
                }
            }
        });
        view.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                }
            }

            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        e.consume();
                    }
                    case 32: {
                        FindResultsPanel.this.selectResource();
                        break;
                    }
                    default: {
                        if (e.isActionKey()) break;
                        FindResultsPanel.this.requestFocus();
                    }
                }
            }
        });
        this.searchTypeCombo = this.createTypeCombo();
        this.searchAsYouTypeCheckbox = this.createSearchAsYouType();
        this.refreshSearchAsYouType();
        JPanel northPanel = new JPanel();
        northPanel.add(new JLabel(SEARCH_PATTERN_LABEL));
        northPanel.add(this.searchTypeCombo);
        northPanel.add(this.textField);
        northPanel.add(this.searchAsYouTypeCheckbox);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)northPanel, "North");
        this.mainPanel.add((Component)view, "Center");
        this.add((Component)this.mainPanel, "Center");
    }

    public void setSearcher(Find s) {
        this.find = s;
    }

    public void setSaveResultsEnabled(boolean canSave) {
        if (canSave) {
            if (this.saveResultButton == null) {
                this.saveResultButton = new JButton(this.saveResultsAction);
                this.mainPanel.add((Component)this.saveResultButton, "South");
            }
        } else if (this.saveResultButton != null) {
            this.mainPanel.remove(this.saveResultButton);
            this.saveResultButton = null;
        }
    }

    public void refresh() {
        this.refresh(this.find.getSearchType());
    }

    public void refresh(int searchType) {
        String string = this.textField.getText();
        this.find.cancelSearch();
        this.find.startSearch(string, searchType);
    }

    public void selectResource() {
        this.view.selectResource();
        this.find.cancelSearch();
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    private JTextField createTextField() {
        JTextField tField = new JTextField();
        FontMetrics metrics = this.getFontMetrics(tField.getFont());
        int textheight = metrics.getHeight() + metrics.getDescent();
        tField.setPreferredSize(new Dimension(120, textheight));
        tField.setText(this.find.getLastSearch());
        tField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        if (!searchAsYouType) {
                            FindResultsPanel.this.refresh();
                        }
                    }
                    case 40: {
                        FindResultsPanel.this.view.requestFocus();
                    }
                }
            }
        });
        return tField;
    }

    private JComboBox createTypeCombo() {
        JComboBox<Object> combo = new JComboBox<Object>();
        combo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                value = Find.searchTypeString[(Integer)value];
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        combo.addItem(new Integer(1));
        combo.addItem(new Integer(0));
        combo.addItem(new Integer(2));
        combo.addItem(new Integer(3));
        combo.setSelectedItem(new Integer(this.find.getSearchType()));
        combo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                int newValue = (Integer)e.getItem();
                int oldValue = FindResultsPanel.this.find.getSearchType();
                if (oldValue != newValue) {
                    FindResultsPanel.this.refresh(newValue);
                }
            }
        });
        return combo;
    }

    private JCheckBox createSearchAsYouType() {
        JCheckBox cBox = new JCheckBox(new AbstractAction(SEARCH_AS_YOU_TYPE_LABEL){

            public void actionPerformed(ActionEvent e) {
                FindResultsPanel.this.refreshSearchAsYouType();
            }
        });
        cBox.setSelected(searchAsYouType);
        return cBox;
    }

    private void refreshSearchAsYouType() {
        searchAsYouType = this.searchAsYouTypeCheckbox.isSelected();
        if (searchAsYouType) {
            this.textField.getDocument().addDocumentListener(this.searchAsYouTypeListener);
        } else {
            this.textField.getDocument().removeDocumentListener(this.searchAsYouTypeListener);
        }
    }
}

