/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResult;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchAdapter;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchListener;
import edu.stanford.smi.protegex.owl.ui.search.finder.ThreadedFind;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;

public class ResultsViewModelFind
extends AbstractTableModel
implements Find,
ListModel {
    protected List orderedKeys;
    private HashMap map;
    private List listeners = new ArrayList(1);
    private Find findAlg;

    public ResultsViewModelFind(OWLModel owlModel, int type) {
        this.findAlg = new ThreadedFind(owlModel, type){

            protected boolean isValidFrameToSearch(Frame f) {
                return super.isValidFrameToSearch(f) && ResultsViewModelFind.this.isValidFrameToSearch(f);
            }
        };
        this.findAlg.addResultListener(new SearchAdapter(){

            public void searchEvent(Find source) {
                ResultsViewModelFind.this.fireDataChanged();
            }
        });
    }

    public int getSize() {
        if (this.orderedKeys != null) {
            return this.orderedKeys.size();
        }
        return 0;
    }

    public synchronized Object getElementAt(int index) {
        return this.orderedKeys.get(index);
    }

    public void addListDataListener(ListDataListener l) {
        this.listeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listeners.remove(l);
    }

    public int getRowCount() {
        return this.getSize();
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int column) {
        return FindResult.getColumnName(column);
    }

    public synchronized Object getValueAt(int rowIndex, int columnIndex) {
        if (this.orderedKeys.size() > rowIndex) {
            Object key = this.orderedKeys.get(rowIndex);
            FindResult item = (FindResult)this.map.get(key);
            return item.get(columnIndex);
        }
        return null;
    }

    private synchronized void fireDataChanged() {
        this.map = new HashMap(this.getResults());
        this.orderedKeys = new LinkedList(this.map.keySet());
        ListDataEvent e = new ListDataEvent(this, 0, 0, this.getSize());
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((ListDataListener)i.next()).contentsChanged(e);
        }
        this.fireTableDataChanged();
    }

    public void startSearch(String s) {
        this.findAlg.startSearch(s);
    }

    public void startSearch(String s, int searchType) {
        this.findAlg.startSearch(s, searchType);
    }

    public void cancelSearch() {
        this.findAlg.cancelSearch();
    }

    public Map getResults() {
        return this.findAlg.getResults();
    }

    public Set getResultResources() {
        return this.findAlg.getResultResources();
    }

    public int getResultCount() {
        return this.findAlg.getResultCount();
    }

    public String getLastSearch() {
        return this.findAlg.getLastSearch();
    }

    public String getSummaryText() {
        return this.findAlg.getSummaryText();
    }

    public String getDescription() {
        return this.findAlg.getDescription();
    }

    public OWLModel getModel() {
        return this.findAlg.getModel();
    }

    public int getNumSearchProperties() {
        return this.findAlg.getNumSearchProperties();
    }

    public int getSearchType() {
        return this.findAlg.getSearchType();
    }

    public void addResultListener(SearchListener l) {
        this.findAlg.addResultListener(l);
    }

    public boolean removeResultListener(SearchListener l) {
        return this.findAlg.removeResultListener(l);
    }

    protected boolean isValidFrameToSearch(Frame f) {
        return true;
    }
}

