/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.search.finder.AbstractFindResultsView;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResultsPanel;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchAdapter;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public class RetainFindResultsPanel
extends ResultsPanel {
    private FindResultsPanel resultsPanel;
    private String tabName = "Search";
    private Action refreshAction = new AbstractAction("Refresh", OWLIcons.getImageIcon("Refresh")){

        public void actionPerformed(ActionEvent e) {
            RetainFindResultsPanel.this.resultsPanel.refresh();
        }
    };

    public RetainFindResultsPanel(Find find, AbstractFindResultsView view) {
        super(find.getModel());
        this.resultsPanel = new FindResultsPanel(find, view);
        find.addResultListener(new SearchAdapter(){

            public void searchEvent(Find source) {
                RetainFindResultsPanel.this.rename(source.getSummaryText());
            }
        });
        this.setCenterComponent(this.resultsPanel);
        this.addButton(this.refreshAction);
    }

    public RetainFindResultsPanel(OWLModel owlModel, FindResultsPanel panel) {
        super(owlModel);
        this.resultsPanel = panel;
        this.setCenterComponent(this.resultsPanel);
        this.addButton(this.refreshAction);
    }

    public Icon getIcon() {
        return Icons.getFindIcon();
    }

    public String getTabName() {
        return this.tabName;
    }

    private void rename(String label) {
        this.tabName = label;
        OWLModel omodel = (OWLModel)ProjectManager.getProjectManager().getCurrentProject().getKnowledgeBase();
        JTabbedPane t = ResultsPanelManager.getTabbedPane(omodel);
        if (t != null) {
            int i = 0;
            while (i < t.getTabCount()) {
                ResultsPanel tab = (ResultsPanel)t.getComponentAt(i);
                if (tab == this) {
                    t.setMnemonicAt(i, 70);
                    t.setTitleAt(i, this.tabName);
                }
                ++i;
            }
        }
        this.revalidate();
    }

    public void requestDispose(JComponent source) {
    }
}

