/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.BrowserComparator;
import edu.stanford.smi.protege.ui.Finder;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.WaitCursor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;

public class SubsumptionTreeFinder
extends Finder {
    private KnowledgeBase kb;
    private Slot superclassesProperty;
    private JTree tree;

    public SubsumptionTreeFinder(KnowledgeBase kb, JTree tree, String description, Slot upProperty) {
        super(description);
        this.kb = kb;
        this.tree = tree;
        this.superclassesProperty = upProperty;
    }

    protected int getBestMatch(List matches, String text) {
        Instance instance;
        String browserText;
        int index;
        int result = Collections.binarySearch(matches, text, new BrowserComparator());
        if (result < 0 && (index = -(result + 1)) < matches.size() && (browserText = (instance = (Instance)matches.get(index)).getBrowserText().toLowerCase()).startsWith(text.toLowerCase())) {
            result = index;
        }
        return result;
    }

    protected List getMatches(String text, int maxMatches) {
        Cls kbRoot = this.kb.getRootCls();
        List matches = this.getMatchingClses(text, maxMatches);
        LazyTreeRoot root = (LazyTreeRoot)this.tree.getModel().getRoot();
        HashSet rootNodes = new HashSet((Collection)root.getUserObject());
        if (rootNodes.size() != 1 || !SubsumptionTreeFinder.equals((Object)CollectionUtilities.getFirstItem(rootNodes), (Object)kbRoot)) {
            Iterator i = matches.iterator();
            while (i.hasNext()) {
                Cls cls = (Cls)i.next();
                boolean isValid = rootNodes.contains(cls);
                if (!isValid) {
                    Set superclasses = this.kb.getDirectOwnSlotValuesClosure((Frame)cls, this.superclassesProperty);
                    isValid = superclasses.removeAll(rootNodes);
                }
                if (isValid) continue;
                i.remove();
            }
        }
        Collections.sort(matches, new FrameComparator());
        return matches;
    }

    private List getMatchingClses(String text, int maxMatches) {
        if (!text.endsWith("*")) {
            text = String.valueOf(text) + '*';
        }
        Slot slot = this.kb.getDefaultClsMetaCls().getBrowserSlotPattern().getFirstSlot();
        ArrayList matches = new ArrayList(this.kb.getMatchingFrames(slot, null, false, text, maxMatches));
        Iterator i = matches.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (o instanceof Cls) continue;
            i.remove();
        }
        return matches;
    }

    private void getVisiblePathToRoot(Cls cls, Collection path) {
        ArrayList roots = new ArrayList((Collection)((LazyTreeNode)this.tree.getModel().getRoot()).getUserObject());
        Iterator i = roots.iterator();
        while (i.hasNext()) {
            Cls root = (Cls)i.next();
            if (root.isVisible()) continue;
            i.remove();
        }
        path.add(cls);
        boolean succeeded = this.getVisiblePathToRoot(cls, roots, path);
        if (!succeeded) {
            Log.getLogger().warning("No visible path found to " + cls);
        }
    }

    private boolean getVisiblePathToRoot(Cls cls, Collection roots, Collection path) {
        boolean found = false;
        Iterator i = cls.getDirectOwnSlotValues(this.superclassesProperty).iterator();
        while (i.hasNext() && !found) {
            Cls parent = (Cls)i.next();
            if (!parent.isVisible()) continue;
            path.add(parent);
            found = roots.contains(parent) ? true : this.getVisiblePathToRoot(parent, roots, path);
            if (found) continue;
            path.remove(parent);
        }
        return found;
    }

    protected void select(Object o) {
        Cls cls = (Cls)o;
        WaitCursor cursor = new WaitCursor((Component)((Object)this));
        try {
            ArrayList clses = new ArrayList();
            this.getVisiblePathToRoot(cls, clses);
            Collections.reverse(clses);
            ComponentUtilities.setSelectedObjectPath((JTree)this.tree, clses);
        }
        finally {
            cursor.hide();
        }
    }

    public String toString() {
        return "SubsumptionTreeFinder";
    }
}

