/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.AbstractTask;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.Task;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLModel;
import edu.stanford.smi.protegex.owl.testing.OWLModelTest;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestManager;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RDFResourceTest;
import edu.stanford.smi.protegex.owl.testing.RDFSClassTest;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanelManager;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public abstract class AbstractOWLTestAction
extends AbstractAction {
    protected OWLModel owlModel;
    protected OWLTestManager testManager;

    public AbstractOWLTestAction() {
    }

    public AbstractOWLTestAction(OWLModel owlModel, OWLTestManager testManager, String text, Icon icon) {
        super(text, icon);
        this.owlModel = owlModel;
        this.testManager = testManager;
    }

    public void actionPerformed(ActionEvent e) {
        OWLTest[] tests = this.getOWLTests();
        if (tests.length == 0) {
            ProtegeUI.getModalDialogFactory().showMessageDialog(this.owlModel, "There are no tests activated.");
        } else if (!OWLUI.isConfirmationNeeded(this.owlModel) || OWLUI.isConfirmed(this.owlModel, this.owlModel.getRDFResourceCount() > OWLUI.getConfirmationThreshold(this.owlModel))) {
            this.performAction(tests);
        }
    }

    private void performAction(final OWLTest[] tests) {
        AbstractTask task = new AbstractTask("Running Tests", true, this.owlModel.getTaskManager()){

            public void runTask() throws Exception {
                List results = AbstractOWLTestAction.this.run(tests, this);
                if (results.isEmpty()) {
                    AbstractOWLTestAction.this.showAllTestsPassedMessage(tests.length);
                }
                AbstractOWLTestAction.this.showResults(results, AbstractOWLTestAction.this.owlModel);
            }
        };
        try {
            this.owlModel.getTaskManager().run(task);
        }
        catch (Exception e) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", e);
        }
    }

    protected OWLTest[] getOWLTests() {
        return this.testManager.getOWLTests();
    }

    protected OWLTestResultsPanel getTestResultsPanel(OWLModel owlModel, List results) {
        return new OWLTestResultsPanel(owlModel, results, null, true);
    }

    protected abstract List run(OWLTest[] var1, Task var2);

    protected void runOWLClsTest(List results, RDFSClassTest test) {
        Collection owlSystemFrames = ((AbstractOWLModel)this.owlModel).getOWLSystemResources();
        for (RDFSClass rdfsClass : this.owlModel.getRDFSClasses()) {
            if (owlSystemFrames.contains(rdfsClass)) continue;
            results.addAll(test.test(rdfsClass));
        }
    }

    protected void runOWLInstanceTest(List results, RDFResourceTest test) {
        Collection owlSystemFrames = ((AbstractOWLModel)this.owlModel).getOWLSystemResources();
        for (RDFSClass rdfsClass : this.owlModel.getRDFSClasses()) {
            if (owlSystemFrames.contains(rdfsClass)) continue;
            results.addAll(test.test(rdfsClass));
        }
        for (OWLProperty owlProperty : this.owlModel.getUserDefinedOWLProperties()) {
            results.addAll(test.test(owlProperty));
        }
        for (RDFResource RDFResource2 : this.owlModel.getOWLIndividuals()) {
            results.addAll(test.test(RDFResource2));
        }
    }

    protected void runOWLModelTest(List results, OWLModelTest test) {
        results.addAll(test.test(this.owlModel));
    }

    protected void runOWLPropertyTest(List results, RDFPropertyTest test) {
        for (OWLProperty owlProperty : this.owlModel.getUserDefinedOWLProperties()) {
            results.addAll(test.test(owlProperty));
        }
    }

    protected void showAllTestsPassedMessage(int count) {
    }

    public void showResults(List results, OWLModel owlModel) {
        OWLTestResultsPanel panel = this.getTestResultsPanel(owlModel, results);
        ResultsPanelManager.addResultsPanel(owlModel, panel, true);
    }
}

