/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.OWLIndividualsTab;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertiesTab;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsTableModel;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsTableModelColumns;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OWLTestResultsPanel
extends ResultsPanel
implements OWLTestResultsTableModelColumns {
    private JFileChooser fileChooser;
    private OWLModel owlModel;
    private OWLTestResultsTableModel tableModel;
    private JTable table;
    private Instance testSource;
    private Action repairAction = new AbstractAction("Repair selected item", OWLIcons.getImageIcon("Repair")){

        public void actionPerformed(ActionEvent e) {
            OWLTestResultsPanel.this.repairSelectedTestResult();
        }
    };
    private Action repairAllAction = new AbstractAction("Repair all repairable items", OWLIcons.getImageIcon("RepairAll")){

        public void actionPerformed(ActionEvent e) {
            OWLTestResultsPanel.this.repairAllTestResults();
        }
    };
    private Action saveAction = new AbstractAction("Save list to file...", OWLIcons.getImageIcon("TestSave")){

        public void actionPerformed(ActionEvent e) {
            OWLTestResultsPanel.this.save();
        }
    };
    private Action settingsAction = new AbstractAction("Test settings...", OWLIcons.getTestSettingsIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLTestSettingsPanel.showOWLTestSettingsDialog(OWLTestResultsPanel.this.owlModel);
        }
    };
    private Action viewAction = new AbstractAction("View resource", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLTestResultsPanel.this.viewSelectedHostInstance();
        }
    };
    public static MouseListener mouseListener = new MouseAdapter(){

        public void mouseEntered(MouseEvent event) {
            AbstractButton button = this.getButton(event);
            button.setBorderPainted(button.isEnabled());
        }

        public void mouseExited(MouseEvent event) {
            this.getButton(event).setBorderPainted(false);
        }

        private AbstractButton getButton(MouseEvent event) {
            return (AbstractButton)event.getSource();
        }
    };

    public OWLTestResultsPanel(OWLModel owlModel, Collection items, Instance testSource, boolean withButtons) {
        super(owlModel);
        this.owlModel = owlModel;
        this.testSource = testSource;
        this.tableModel = new OWLTestResultsTableModel(owlModel, items);
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.table.setAutoResizeMode(3);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                OWLTestResultsPanel.this.enableActions();
            }
        });
        this.table.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        this.table.getColumnModel().getColumn(1).setPreferredWidth(60);
        TableColumn typeColumn = this.table.getColumnModel().getColumn(0);
        typeColumn.setPreferredWidth(64);
        typeColumn.setMaxWidth(64);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(400);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && OWLTestResultsPanel.this.viewAction.isEnabled()) {
                    OWLTestResultsPanel.this.viewAction.actionPerformed(null);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.getViewport().setBackground(this.table.getBackground());
        this.viewAction.setEnabled(false);
        this.repairAction.setEnabled(false);
        this.repairAllAction.setEnabled(true);
        if (withButtons) {
            this.addButton(this.repairAction);
            this.addButton(this.repairAllAction);
            this.addButton(this.settingsAction);
            this.addButton(this.saveAction);
        }
        this.setCenterComponent(scrollPane);
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    private void enableActions() {
        int sel = this.table.getSelectedRow();
        if (sel >= 0) {
            OWLTestResult result = this.tableModel.getOWLTestResult(sel);
            OWLTest test = result.getOWLTest();
            this.repairAction.setEnabled(test instanceof RepairableOWLTest);
        } else {
            this.repairAction.setEnabled(false);
        }
        this.viewAction.setEnabled(sel >= 0);
        this.repairAllAction.setEnabled(sel >= 0);
    }

    protected String[] getDisplayTabClassNames(RDFResource instance) {
        if (instance instanceof RDFSClass) {
            return new String[]{OWLClassesTab.class.getName()};
        }
        if (instance instanceof OWLProperty) {
            return new String[]{OWLPropertiesTab.class.getName()};
        }
        return new String[]{OWLIndividualsTab.class.getName()};
    }

    public Icon getIcon() {
        return OWLIcons.getTestIcon();
    }

    public String getTabName() {
        if (this.testSource == null) {
            return "Test Results";
        }
        return "Tests of " + this.testSource.getBrowserText();
    }

    protected OWLTestResultsTableModel getTableModel() {
        return this.tableModel;
    }

    protected JTable getTable() {
        return this.table;
    }

    private void repairSelectedTestResult() {
        int row = this.table.getSelectedRow();
        OWLTestResult result = this.tableModel.getOWLTestResult(row);
        RepairableOWLTest test = (RepairableOWLTest)result.getOWLTest();
        try {
            try {
                this.owlModel.beginTransaction("Repair test for " + result.getHost().getBrowserText() + ": " + result.getMessage());
                boolean repaired = test.repair(result);
                if (repaired) {
                    this.tableModel.removeRow(row);
                }
            }
            catch (Exception ex) {
                OWLUI.handleError(this.owlModel, ex);
            }
        }
        finally {
            this.owlModel.endTransaction();
        }
    }

    private void repairAllTestResults() {
        int numResults = this.tableModel.getRowCount();
        int i = numResults - 1;
        while (i >= 0) {
            OWLTestResult result = this.tableModel.getOWLTestResult(i);
            OWLTest test = result.getOWLTest();
            if (test instanceof RepairableOWLTest) {
                try {
                    try {
                        this.owlModel.beginTransaction("Repair test for " + result.getHost().getBrowserText() + ": " + result.getMessage());
                        boolean repaired = ((RepairableOWLTest)test).repair(result);
                        if (repaired) {
                            this.tableModel.removeRow(i);
                        }
                    }
                    catch (Exception ex) {
                        OWLUI.handleError(this.owlModel, ex);
                    }
                }
                finally {
                    this.owlModel.endTransaction();
                }
            }
            --i;
        }
    }

    private void save() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if (this.fileChooser.showSaveDialog(this) == 0) {
            File file = this.fileChooser.getSelectedFile();
            String message = this.tableModel.saveToFile(file);
            if (message == null) {
                JOptionPane.showMessageDialog(this, "The list has been saved to " + file);
            } else {
                JOptionPane.showMessageDialog(this, "Could not save list:\n" + message, "Error", 0);
            }
        }
    }

    public void setResults(List results) {
        this.tableModel.setItems(results);
    }

    private void viewSelectedHostInstance() {
        int row = this.table.getSelectedRow();
        RDFResource hostResource = this.tableModel.getSource(row);
        if (hostResource != null) {
            this.showHostResource(hostResource);
        }
    }
}

