/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.table.AbstractTableModel;

class TripleStoreTableModel
extends AbstractTableModel {
    public static final int COL_EDITABLE = 0;
    public static final int COL_ACTIVE = 1;
    public static final int COL_URI = 2;
    public static final int COL_COUNT = 3;
    private OWLModel owlModel;
    public static final String MAIN_FILE_NAME = "<Main File>";

    TripleStoreTableModel(OWLModel owlModel) {
        this.owlModel = owlModel;
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 1 || columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    public String getColumnName(int column) {
        if (column == 1) {
            return "Active";
        }
        if (column == 2) {
            return "URI";
        }
        if (column == 0) {
            return "Editable";
        }
        return null;
    }

    public int getRowCount() {
        return this.owlModel.getTripleStoreModel().getTripleStores().size() - 1;
    }

    public int getSelectedTripleStoreRow() {
        int i = 0;
        while (i < this.getRowCount()) {
            if (Boolean.TRUE.equals(this.getValueAt(i, 1))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    TripleStore getTripleStore(int row) {
        return (TripleStore)this.owlModel.getTripleStoreModel().getTripleStores().get(row + 1);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        TripleStore tripleStore = this.getTripleStore(rowIndex);
        String uri = tripleStore.getName();
        if (columnIndex == 1) {
            return tripleStore == this.owlModel.getTripleStoreModel().getActiveTripleStore();
        }
        if (columnIndex == 2) {
            if (rowIndex == 0) {
                return "<Main ontology>";
            }
            return uri;
        }
        if (columnIndex == 0) {
            if (rowIndex == 0) {
                return Boolean.TRUE;
            }
            try {
                RepositoryManager man = this.owlModel.getRepositoryManager();
                URI ontURI = new URI(uri);
                Repository rep = man.getRepository(ontURI);
                if (rep != null) {
                    return rep.isWritable(ontURI);
                }
                return Boolean.FALSE;
            }
            catch (URISyntaxException e) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return Boolean.TRUE.equals(this.getValueAt(rowIndex, 0));
        }
        if (columnIndex == 0) {
            return false;
        }
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1 && Boolean.TRUE.equals(aValue)) {
            TripleStore tripleStore = this.getTripleStore(rowIndex);
            TripleStoreUtil.switchTripleStore(this.owlModel, tripleStore);
            int row = 0;
            while (row < this.getRowCount()) {
                this.fireTableCellUpdated(row, columnIndex);
                ++row;
            }
        }
    }
}

