/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JProgressBar;

public class ModalProgressBarDialog
extends JDialog
implements Runnable {
    private JProgressBar progressBar;
    private LabeledComponent labeledComponent;

    public ModalProgressBarDialog(int min, int max, Frame parentFrame, String title) {
        super(parentFrame);
        this.setTitle(title);
        this.progressBar = new JProgressBar(min, max);
        this.progressBar.setIndeterminate(false);
        this.init();
    }

    private void init() {
        this.progressBar.setValue(0);
        this.setModal(true);
        this.setSize(200, 100);
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.labeledComponent = new LabeledComponent("-------------------------------------------", (Component)this.progressBar);
        contentPane.add("Center", (Component)this.labeledComponent);
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ComponentUtilities.center((Component)this);
    }

    public void run() {
        this.show();
    }

    public void setLabel(String text) {
        this.labeledComponent.setHeaderLabel(text);
    }

    public boolean setValue(int value) {
        if (value != this.progressBar.getValue()) {
            this.progressBar.setValue(value);
            JComponent repaintComponent = (JComponent)this.getContentPane();
            Dimension size = repaintComponent.getSize();
            repaintComponent.paintImmediately(new Rectangle(0, 0, size.width, size.height));
            return true;
        }
        return false;
    }

    public boolean setValueRelative(double value) {
        int v = (int)((double)(this.progressBar.getMaximum() - this.progressBar.getMinimum()) * value);
        return this.setValue(v);
    }
}

