/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.toedter.calendar.JDateChooser;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class OWLDateWidget
extends AbstractPropertyWidget {
    private JDateChooser dateChooser;
    private Action deleteAction = new AbstractAction("Delete value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLDateWidget.this.deleteValue();
        }
    };
    private LabeledComponent lc;
    private Action setAction = new AbstractAction("Set value", OWLIcons.getAddIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLDateWidget.this.setPropertyValue(new Date());
        }
    };
    private boolean ignoreUpdate = false;

    public OWLDateWidget() {
        this.setPreferredColumns(2);
        this.setPreferredRows(1);
    }

    protected RDFSLiteral createPropertyValue(Date date) {
        String value = XMLSchemaDatatypes.getDateString(date);
        RDFSDatatype datatype = this.getOWLModel().getRDFSDatatypeByURI(XSDDatatype.XSDdate.getURI());
        return this.getOWLModel().createRDFSLiteral(value, datatype);
    }

    protected void deleteValue() {
        this.getEditedResource().setPropertyValue(this.getRDFProperty(), null);
    }

    protected Component getCenterComponent() {
        return this.dateChooser;
    }

    protected Date getDate() {
        return this.dateChooser.getDate();
    }

    public static Date getDate(String s) {
        Date date = new Date();
        if (s != null) {
            String[] ss;
            int index = s.indexOf("T");
            if (index >= 0) {
                s = s.substring(0, index);
            }
            if ((ss = s.split("-")).length >= 3) {
                try {
                    int year = Integer.parseInt(ss[0]);
                    int month = Integer.parseInt(ss[1]) - 1;
                    int day = Integer.parseInt(ss[2]);
                    date = new Date(new GregorianCalendar(year, month, day).getTimeInMillis());
                }
                catch (Exception ex) {
                    System.err.println("[OWLDateWidget] Could not parse value " + s + ": " + ex);
                }
            }
        }
        return date;
    }

    public void initialize() {
        this.dateChooser = new JDateChooser();
        this.dateChooser.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("date".equals(evt.getPropertyName())) {
                    OWLDateWidget.this.updateValues();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.lc = new LabeledComponent(this.getRDFProperty().getBrowserText(), this.getCenterComponent());
        this.lc.addHeaderButton(this.setAction);
        this.lc.addHeaderButton(this.deleteAction);
        this.add("Center", (Component)this.lc);
    }

    private void setDateChooserValue() {
        RDFProperty property;
        RDFResource resource = this.getEditedResource();
        Object value = resource.getPropertyValue(property = this.getRDFProperty());
        this.setValue(value == null ? null : value.toString());
    }

    protected void setValue(String s) {
        Date date = OWLDateWidget.getDate(s);
        this.dateChooser.setDate(date);
    }

    private void setPropertyValue(Date date) {
        RDFResource resource = this.getEditedResource();
        RDFProperty property = this.getRDFProperty();
        if (resource != null && property != null) {
            RDFSLiteral value = this.createPropertyValue(date);
            resource.setPropertyValue(property, value);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateComponents();
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        if (newInstance != null) {
            this.setDateChooserValue();
        }
        this.updateComponents();
    }

    public void setValues(Collection values) {
        super.setValues(values);
        this.updateComponents();
        this.ignoreUpdate = true;
        this.setDateChooserValue();
        this.ignoreUpdate = false;
    }

    protected void updateComponents() {
        RDFResource resource = this.getEditedResource();
        RDFProperty property = this.getRDFProperty();
        if (resource != null && property != null && resource.isEditable()) {
            boolean value = resource.getPropertyValue(property) != null;
            this.setAction.setEnabled(!value);
            this.deleteAction.setEnabled(value);
            this.dateChooser.setEnabled(value);
            this.lc.revalidate();
        } else {
            this.setAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
            this.dateChooser.setEnabled(false);
        }
    }

    protected void updateValues() {
        if (!this.ignoreUpdate) {
            Date date = this.getDate();
            this.setPropertyValue(date);
        }
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(OWLDateWidget.class, cls, slot);
    }
}

