/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFAxiomRenderer;
import edu.stanford.smi.protegex.owl.writer.rdfxml.renderer.RDFResourceRenderer;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.util.Collection;

public class RDFResourceCollectionContentWriter
implements RDFXMLContentWriter {
    private Collection resources;
    private RDFAxiomRenderer.RenderableAxiomsChecker checker;
    private TripleStore tripleStore;

    public RDFResourceCollectionContentWriter(Collection resources, TripleStore tripleStore) {
        this.resources = resources;
        this.tripleStore = tripleStore;
        this.checker = RDFAxiomRenderer.getChecker();
    }

    public void writeContent(XMLWriter writer) {
        for (RDFResource resource : this.resources) {
            if (this.checker.isRenderable(resource)) {
                RDFAxiomRenderer render = new RDFAxiomRenderer(resource, this.tripleStore, writer);
                render.write();
                continue;
            }
            RDFResourceRenderer renderer = new RDFResourceRenderer(resource, this.tripleStore, writer);
            renderer.write();
        }
    }
}

