/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllDifferent;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.tests.AbstractRDFXMLWriterTestCases;
import java.util.ArrayList;

public class RDFXMLWriterTestCase
extends AbstractRDFXMLWriterTestCases {
    private OWLNamedClass clsA;
    private OWLNamedClass clsB;
    private OWLNamedClass clsC;
    private OWLObjectProperty propP;
    private OWLDatatypeProperty propR;
    private OWLIndividual iA;
    private OWLIndividual iB;

    protected void setUp() throws Exception {
        super.setUp();
        this.clsA = this.owlModel.createOWLNamedClass("A");
        this.clsB = this.owlModel.createOWLNamedClass("B");
        this.clsC = this.owlModel.createOWLNamedClass("C");
        this.propP = this.owlModel.createOWLObjectProperty("p");
        this.propR = this.owlModel.createOWLDatatypeProperty("r");
        this.iA = this.owlModel.getOWLThingClass().createOWLIndividual("iA");
        this.iB = this.owlModel.getOWLThingClass().createOWLIndividual("iB");
    }

    public void testAllDifferent() {
        OWLAllDifferent allDifferent = this.owlModel.createOWLAllDifferent();
        allDifferent.addDistinctMember(this.iA);
        allDifferent.addDistinctMember(this.iB);
        this.doCheck();
    }

    public void testSubClassOf() {
        this.clsA.addSuperclass(this.clsB);
        this.clsA.addSuperclass(this.clsC);
        this.doCheck();
    }

    public void testDisjointWith() {
        this.clsA.addDisjointClass(this.clsB);
        this.doCheck();
    }

    public void testObjectSomeValuesFrom() {
        this.clsA.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.propP, this.clsB));
        this.doCheck();
    }

    public void testDataSomeValuesFrom() {
        this.clsA.addSuperclass(this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.propR, this.owlModel.getXSDint()));
        this.doCheck();
    }

    public void testObjectAllValuesFrom() {
        this.clsB.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)this.propP, this.clsB));
        this.doCheck();
    }

    public void testDataAllValuesFrom() {
        this.clsA.addSuperclass(this.owlModel.createOWLAllValuesFrom((RDFProperty)this.propR, this.owlModel.getXSDint()));
        this.doCheck();
    }

    public void testObjectHasValue() {
        this.clsA.addSuperclass(this.owlModel.createOWLHasValue(this.propP, this.iA));
        this.doCheck();
    }

    public void testDataHasValue() {
        this.clsA.addSuperclass(this.owlModel.createOWLHasValue(this.propR, this.owlModel.createRDFSLiteral("26", this.owlModel.getXSDint())));
        this.doCheck();
    }

    public void testIntersectionOf() {
        OWLIntersectionClass intersectionClass = this.owlModel.createOWLIntersectionClass();
        intersectionClass.addOperand(this.clsB);
        intersectionClass.addOperand(this.clsC);
        this.clsA.addSuperclass(intersectionClass);
        this.doCheck();
    }

    public void testUnionOf() {
        OWLUnionClass unionClass = this.owlModel.createOWLUnionClass();
        unionClass.addOperand(this.clsB);
        unionClass.addOperand(this.clsC);
        this.clsA.addSuperclass(unionClass);
        this.doCheck();
    }

    public void testComplementOf() {
        OWLComplementClass complementClass = this.owlModel.createOWLComplementClass();
        complementClass.setComplement(this.clsB);
        this.clsA.addSuperclass(complementClass);
        this.doCheck();
    }

    public void testOneOf() {
        OWLEnumeratedClass enumeratedClass = this.owlModel.createOWLEnumeratedClass();
        enumeratedClass.addOneOf(this.iA);
        enumeratedClass.addOneOf(this.iB);
        this.clsA.addSuperclass(enumeratedClass);
        this.doCheck();
    }

    public void testMinCardinality() {
        this.clsA.addSuperclass(this.owlModel.createOWLMinCardinality(this.propP, 3));
        this.doCheck();
    }

    public void testCardinality() {
        this.clsA.addSuperclass(this.owlModel.createOWLCardinality(this.propP, 3));
        this.doCheck();
    }

    public void testMaxCardinality() {
        this.clsA.addSuperclass(this.owlModel.createOWLMaxCardinality(this.propP, 3));
        this.doCheck();
    }

    public void testMinQualifiedCardinality() {
        OWLMinCardinality cardinality = this.owlModel.createOWLMinCardinality(this.propP, 3);
        cardinality.setValuesFrom(this.clsA);
        this.clsA.addSuperclass(cardinality);
        this.doCheck();
    }

    public void testQualifiedCardinality() {
        OWLCardinality cardinality = this.owlModel.createOWLCardinality(this.propP, 3);
        cardinality.setValuesFrom(this.clsA);
        this.clsA.addSuperclass(cardinality);
        this.doCheck();
    }

    public void testMaxQualifiedCardinality() {
        OWLMaxCardinality cardinality = this.owlModel.createOWLMaxCardinality(this.propP, 3);
        cardinality.setValuesFrom(this.clsA);
        this.clsA.addSuperclass(cardinality);
        this.doCheck();
    }

    public void testPropertyCharacteristics() {
        this.propP.setFunctional(true);
        this.propP.setInverseFunctional(true);
        this.propP.setSymmetric(true);
        this.propP.setTransitive(true);
        this.doCheck();
    }

    public void testObjectPropertyRange() {
        this.propP.setRange(this.clsA);
        this.doCheck();
    }

    public void testObjectPropertyDomain() {
        this.propP.setDomain(this.clsA);
        this.doCheck();
    }

    public void testDatatypePropertyRange() {
        this.propR.setRange(this.owlModel.getXSDint());
        this.doCheck();
    }

    public void testDatatypePropertyDataRange() {
        RDFSLiteral[] literals = new RDFSLiteral[]{this.owlModel.createRDFSLiteral("26", this.owlModel.getXSDint()), this.owlModel.createRDFSLiteral("33", this.owlModel.getXSDint()), this.owlModel.createRDFSLiteral("44", this.owlModel.getXSDint())};
        OWLDataRange dataRange = this.owlModel.createOWLDataRange(literals);
        this.propR.setRange(dataRange);
        this.doCheck();
    }

    public void testRDFList() {
        ArrayList<RDFResource> list = new ArrayList<RDFResource>();
        list.add(this.iA);
        list.add(this.iB);
        list.add(this.clsA);
        RDFList rdfList = this.owlModel.createRDFList(list.iterator());
        this.iA.addPropertyValue(this.propP, rdfList);
        this.doCheck();
    }

    public void testSameAs() {
        this.iA.addSameAs(this.iB);
        this.doCheck();
    }

    public void testDifferentFrom() {
        this.iA.addDifferentFrom(this.iB);
        this.doCheck();
    }

    public void testAnnotationProperty() {
        OWLObjectProperty prop = this.owlModel.createAnnotationOWLObjectProperty("anno");
        this.doCheck();
    }

    public void testBuiltInAnnotation() {
        OWLUtil.addComment(this.clsA, "A comment");
        this.doCheck();
    }

    public void testBuiltInAnonymousClassAnnotation() {
        OWLSomeValuesFrom restriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.propP, this.clsB);
        OWLUtil.addComment(restriction, "A comment");
        this.clsA.addSuperclass(restriction);
        this.doCheck();
    }

    public void testAnonymousIndividualChain() {
        OWLIndividual anonA = this.clsA.createOWLIndividual(this.owlModel.getNextAnonymousResourceName());
        OWLIndividual anonB = this.clsA.createOWLIndividual(this.owlModel.getNextAnonymousResourceName());
        OWLIndividual anonC = this.clsA.createOWLIndividual(this.owlModel.getNextAnonymousResourceName());
        this.iA.addPropertyValue(this.propP, anonA);
        anonA.addPropertyValue(this.propP, anonB);
        anonB.addPropertyValue(this.propP, anonC);
        this.doCheck();
    }

    public void testDatatypeRelationship() {
        this.iA.addPropertyValue(this.propR, this.owlModel.createRDFSLiteral("33", this.owlModel.getXSDint()));
        this.doCheck();
    }
}

