/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protegex.owl.ProtegeOWL;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import java.util.Collection;
import junit.framework.Assert;

public class CreateNamedClasses {
    public static void main(String[] args) {
        JenaOWLModel owlModel = ProtegeOWL.createJenaOWLModel();
        OWLNamedClass personClass = owlModel.createOWLNamedClass("Person");
        OWLNamedClass brotherClass = owlModel.createOWLNamedClass("Brother");
        brotherClass.addSuperclass(personClass);
        brotherClass.removeSuperclass(owlModel.getOWLThingClass());
        OWLNamedClass sisterClass = owlModel.createOWLNamedSubclass("Sister", personClass);
        CreateNamedClasses.printClassTree(personClass, "");
        OWLIndividual hans = brotherClass.createOWLIndividual("Hans");
        Collection brothers = brotherClass.getInstances(false);
        Assert.assertTrue((boolean)brothers.contains(hans));
        Assert.assertTrue((brothers.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((int)personClass.getInstanceCount(false), (int)0);
        Assert.assertEquals((int)personClass.getInstanceCount(true), (int)0);
        Assert.assertTrue((boolean)personClass.getInstances(true).contains(hans));
        Assert.assertTrue((boolean)hans.getProtegeType().equals(brotherClass));
        Assert.assertTrue((boolean)hans.hasProtegeType(brotherClass));
        Assert.assertFalse((boolean)hans.hasProtegeType(personClass, false));
        Assert.assertTrue((boolean)hans.hasProtegeType(personClass, true));
    }

    private static void printClassTree(RDFSClass cls, String indentation) {
        System.out.println(String.valueOf(indentation) + cls.getName());
        for (RDFSClass subclass : cls.getSubclasses(false)) {
            CreateNamedClasses.printClassTree(subclass, String.valueOf(indentation) + "    ");
        }
    }
}

