/*
 * Decompiled with CFR 0.152.
 */
package org.daml.kazuki;

import com.hp.hpl.jena.datatypes.DatatypeFormatException;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import com.hp.hpl.jena.datatypes.xsd.XSDDuration;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.daml.kazuki.datatypes.XSDduration;
import org.daml.kazuki.datatypes.XSDgDay;
import org.daml.kazuki.datatypes.XSDgMonth;
import org.daml.kazuki.datatypes.XSDgMonthDay;
import org.daml.kazuki.datatypes.XSDgYear;
import org.daml.kazuki.datatypes.XSDgYearMonth;

public class Datatypes {
    private String[][] defaultTypes = new String[][]{{"http://www.w3.org/2001/XMLSchema#ENTITY", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#ID", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#IDREF", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#NCName", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#NMTOKEN", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#NOTATION", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#Name", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#QName", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#anyURI", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#base64Binary", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#boolean", "boolean"}, {"http://www.w3.org/2001/XMLSchema#byte", "byte"}, {"http://www.w3.org/2001/XMLSchema#date", "java.util.Calendar"}, {"http://www.w3.org/2001/XMLSchema#dateTime", "java.util.Calendar"}, {"http://www.w3.org/2001/XMLSchema#decimal", "java.math.BigDecimal"}, {"http://www.w3.org/2001/XMLSchema#double", "double"}, {"http://www.w3.org/2001/XMLSchema#duration", "org.daml.kazuki.datatypes.XSDduration"}, {"http://www.w3.org/2001/XMLSchema#float", "float"}, {"http://www.w3.org/2001/XMLSchema#gDay", "org.daml.kazuki.datatypes.XSDgDay"}, {"http://www.w3.org/2001/XMLSchema#gMonth", "org.daml.kazuki.datatypes.XSDgMonth"}, {"http://www.w3.org/2001/XMLSchema#gMonthDay", "org.daml.kazuki.datatypes.XSDgMonthDay"}, {"http://www.w3.org/2001/XMLSchema#gYear", "org.daml.kazuki.datatypes.XSDgYear"}, {"http://www.w3.org/2001/XMLSchema#gYearMonth", "org.daml.kazuki.datatypes.XSDgYearMonth"}, {"http://www.w3.org/2001/XMLSchema#hexBinary", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#int", "int"}, {"http://www.w3.org/2001/XMLSchema#integer", "java.math.BigInteger"}, {"http://www.w3.org/2001/XMLSchema#language", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#long", "long"}, {"http://www.w3.org/2001/XMLSchema#negativeInteger", "java.math.BigInteger"}, {"http://www.w3.org/2001/XMLSchema#nonNegativeInteger", "java.math.BigInteger"}, {"http://www.w3.org/2001/XMLSchema#nonPositiveInteger", "java.math.BigInteger"}, {"http://www.w3.org/2001/XMLSchema#normalizedString", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#positiveInteger", "java.math.BigInteger"}, {"http://www.w3.org/2001/XMLSchema#short", "short"}, {"http://www.w3.org/2001/XMLSchema#string", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#time", "java.util.Calendar"}, {"http://www.w3.org/2001/XMLSchema#token", "java.lang.String"}, {"http://www.w3.org/2001/XMLSchema#unsignedByte", "short"}, {"http://www.w3.org/2001/XMLSchema#unsignedInt", "long"}, {"http://www.w3.org/2001/XMLSchema#unsignedLong", "long"}, {"http://www.w3.org/2001/XMLSchema#unsignedShort", "int"}, {"http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", "java.lang.String"}};
    private HashMap typeMapping = new HashMap();
    private String[][] defaultMethods = new String[][]{{"java.math.BigDecimal", "org.daml.kazuki.Datatypes.getBigDecimal"}, {"java.math.BigInteger", "org.daml.kazuki.Datatypes.getBigInteger"}, {"java.lang.Boolean", "org.daml.kazuki.Datatypes.getBoolean"}, {"java.lang.Byte", "org.daml.kazuki.Datatypes.getByte"}, {"java.lang.Character", "org.daml.kazuki.Datatypes.getCharacter"}, {"java.lang.Double", "org.daml.kazuki.Datatypes.getDouble"}, {"java.lang.Float", "org.daml.kazuki.Datatypes.getFloat"}, {"java.lang.Integer", "org.daml.kazuki.Datatypes.getInteger"}, {"java.lang.Long", "org.daml.kazuki.Datatypes.getLong"}, {"java.lang.Short", "org.daml.kazuki.Datatypes.getShort"}, {"java.lang.String", "org.daml.kazuki.Datatypes.getString"}, {"boolean", "org.daml.kazuki.Datatypes.getboolean"}, {"byte", "org.daml.kazuki.Datatypes.getbyte"}, {"double", "org.daml.kazuki.Datatypes.getdouble"}, {"char", "org.daml.kazuki.Datatypes.getchar"}, {"float", "org.daml.kazuki.Datatypes.getfloat"}, {"int", "org.daml.kazuki.Datatypes.getint"}, {"long", "org.daml.kazuki.Datatypes.getlong"}, {"short", "org.daml.kazuki.Datatypes.getshort"}, {"java.util.Calendar", "org.daml.kazuki.Datatypes.getCalendar"}, {"org.daml.kazuki.datatypes.XSDgYear", "org.daml.kazuki.Datatypes.getgYear"}, {"org.daml.kazuki.datatypes.XSDgMonth", "org.daml.kazuki.Datatypes.getgMonth"}, {"org.daml.kazuki.datatypes.XSDgDay", "org.daml.kazuki.Datatypes.getgDay"}, {"org.daml.kazuki.datatypes.XSDgYearMonth", "org.daml.kazuki.Datatypes.getgYearMonth"}, {"org.daml.kazuki.datatypes.XSDgMonthDay", "org.daml.kazuki.Datatypes.getgMonthDay"}, {"org.daml.kazuki.datatypes.XSDduration", "org.daml.kazuki.Datatypes.getDuration"}};
    private HashMap methodMapping = new HashMap();
    private static final SimpleDateFormat XSD_date = new SimpleDateFormat("yyyy-MM-ddZ");
    private static final SimpleDateFormat XSD_dateTime = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat XSD_time = new SimpleDateFormat("HH:mm:ss.SSSZ");
    private static final SimpleDateFormat XSD_gDay = new SimpleDateFormat("---ddZ");
    private static final SimpleDateFormat XSD_gMonth = new SimpleDateFormat("--MM--Z");
    private static final SimpleDateFormat XSD_gMonthDay = new SimpleDateFormat("--MM-ddZ");
    private static final SimpleDateFormat XSD_gYear = new SimpleDateFormat("yyyyZ");
    private static final SimpleDateFormat XSD_gYearMonth = new SimpleDateFormat("yyyy-MMZ");

    public Datatypes() {
        this.restoreDefaultTypes();
        this.restoreDefaultMethods();
    }

    public void restoreDefaultTypes() {
        this.typeMapping.clear();
        int n = 0;
        while (n < this.defaultTypes.length) {
            this.typeMapping.put(this.defaultTypes[n][0], this.defaultTypes[n][1]);
            ++n;
        }
    }

    public void restoreDefaultMethods() {
        this.methodMapping.clear();
        int n = 0;
        while (n < this.defaultMethods.length) {
            this.methodMapping.put(this.defaultMethods[n][0], this.defaultMethods[n][1]);
            ++n;
        }
    }

    public void printTypeMapping(PrintWriter printWriter) {
        Iterator iterator = this.typeMapping.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.typeMapping.get(string);
            printWriter.write(string + " >> " + string2 + "\n");
        }
        printWriter.flush();
    }

    public void printMethodMapping(PrintWriter printWriter) {
        Iterator iterator = this.methodMapping.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.methodMapping.get(string);
            printWriter.write(string + " >> " + string2 + "\n");
        }
        printWriter.flush();
    }

    public void setType(String string, String string2) {
        this.typeMapping.put(string, string2);
    }

    public String getType(String string) {
        return (String)this.typeMapping.get(string);
    }

    public void parseTypeMapping(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        boolean bl = false;
        int n = 0;
        while (!bl) {
            String string2 = bufferedReader.readLine();
            ++n;
            if (string2 == null) {
                bl = true;
                continue;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t");
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string3 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    System.err.println("Type Mapping file format is incorrect at line " + n);
                }
                this.setType(string3, string4);
                continue;
            }
            System.err.println("Type Mapping file format is incorrect at line " + n);
        }
    }

    public void setMethod(String string, String string2) {
        this.methodMapping.put(string, string2);
    }

    public String getMethod(String string) {
        return (String)this.methodMapping.get(string);
    }

    public static String getString(Literal literal) {
        return literal.getString();
    }

    public static int getint(Literal literal) {
        return literal.getInt();
    }

    public static byte getbyte(Literal literal) {
        return literal.getByte();
    }

    public static short getshort(Literal literal) {
        return literal.getShort();
    }

    public static double getdouble(Literal literal) {
        return literal.getDouble();
    }

    public static long getlong(Literal literal) {
        return literal.getLong();
    }

    public static float getfloat(Literal literal) {
        return literal.getFloat();
    }

    public static boolean getboolean(Literal literal) {
        return literal.getBoolean();
    }

    public static char getchar(Literal literal) {
        return literal.getChar();
    }

    public static Integer getInteger(Literal literal) {
        return new Integer(literal.getInt());
    }

    public static Byte getByte(Literal literal) {
        return new Byte(literal.getByte());
    }

    public static Short getShort(Literal literal) {
        return new Short(literal.getShort());
    }

    public static Double getDouble(Literal literal) {
        return new Double(literal.getDouble());
    }

    public static Long getLong(Literal literal) {
        return new Long(literal.getLong());
    }

    public static Float getFloat(Literal literal) {
        return new Float(literal.getFloat());
    }

    public static Boolean getBoolean(Literal literal) {
        return new Boolean(literal.getBoolean());
    }

    public static Character getCharacter(Literal literal) {
        return new Character(literal.getChar());
    }

    public static Calendar getCalendar(Literal literal) {
        try {
            Object object = literal.getValue();
            if (object instanceof Calendar) {
                return (Calendar)object;
            }
            if (object instanceof XSDDateTime) {
                Calendar calendar = ((XSDDateTime)object).asCalendar();
                calendar.set(2, calendar.get(2) - 1);
                return calendar;
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {}
        return null;
    }

    public static XSDgYear getgYear(Literal literal) {
        try {
            Object object = literal.getValue();
            if (object instanceof XSDgYear) {
                return (XSDgYear)object;
            }
            if (object instanceof XSDDateTime) {
                return new XSDgYear((XSDDateTime)object);
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {}
        return null;
    }

    public static XSDgMonth getgMonth(Literal literal) {
        try {
            Object object = literal.getValue();
            if (object instanceof XSDgMonth) {
                return (XSDgMonth)object;
            }
            if (object instanceof XSDDateTime) {
                return new XSDgMonth((XSDDateTime)object);
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {}
        return null;
    }

    public static XSDgDay getgDay(Literal literal) {
        try {
            Object object = literal.getValue();
            if (object instanceof XSDgDay) {
                return (XSDgDay)object;
            }
            if (object instanceof XSDDateTime) {
                return new XSDgDay((XSDDateTime)object);
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {}
        return null;
    }

    public static XSDgYearMonth getgYearMonth(Literal literal) {
        try {
            Object object = literal.getValue();
            if (object instanceof XSDgYearMonth) {
                return (XSDgYearMonth)object;
            }
            if (object instanceof XSDDateTime) {
                return new XSDgYearMonth((XSDDateTime)object);
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {}
        return null;
    }

    public static XSDgMonthDay getgMonthDay(Literal literal) {
        try {
            Object object = literal.getValue();
            if (object instanceof XSDgMonthDay) {
                return (XSDgMonthDay)object;
            }
            if (object instanceof XSDDateTime) {
                return new XSDgMonthDay((XSDDateTime)object);
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {}
        return null;
    }

    public static XSDduration getDuration(Literal literal) {
        try {
            Object object = literal.getValue();
            if (object instanceof XSDduration) {
                return (XSDduration)object;
            }
            if (object instanceof XSDDuration) {
                return new XSDduration((XSDDuration)object);
            }
        }
        catch (DatatypeFormatException datatypeFormatException) {}
        return null;
    }

    public static BigInteger getBigInteger(Literal literal) {
        Object object = literal.getValue();
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            try {
                return new BigInteger(number.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static BigDecimal getBigDecimal(Literal literal) {
        Object object = literal.getValue();
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            try {
                return new BigDecimal(number.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static Literal createTypedLiteral(Model model, Object object, String string) {
        RDFDatatype rDFDatatype = TypeMapper.getInstance().getTypeByName(string);
        if (object instanceof Calendar) {
            String string2 = Datatypes.CalendarToXSD((Calendar)object, rDFDatatype);
            if (rDFDatatype.isValidValue((Object)string2)) {
                return model.createTypedLiteral(string2, string);
            }
            throw new DatatypeFormatException(string2, rDFDatatype, "Value does not match datatype.");
        }
        if (rDFDatatype.isValid(object.toString())) {
            return model.createTypedLiteral(object.toString(), string);
        }
        throw new DatatypeFormatException(object.toString(), rDFDatatype, "Value does not match datatype.");
    }

    public static Literal createTypedLiteral(Model model, boolean bl, String string) {
        return Datatypes.createTypedLiteral(model, new Boolean(bl), string);
    }

    public static Literal createTypedLiteral(Model model, byte by, String string) {
        return Datatypes.createTypedLiteral(model, new Byte(by), string);
    }

    public static Literal createTypedLiteral(Model model, char c, String string) {
        return Datatypes.createTypedLiteral(model, new Character(c), string);
    }

    public static Literal createTypedLiteral(Model model, double d, String string) {
        return Datatypes.createTypedLiteral(model, new Double(d), string);
    }

    public static Literal createTypedLiteral(Model model, float f, String string) {
        return Datatypes.createTypedLiteral(model, new Float(f), string);
    }

    public static Literal createTypedLiteral(Model model, int n, String string) {
        return Datatypes.createTypedLiteral(model, new Integer(n), string);
    }

    public static Literal createTypedLiteral(Model model, long l, String string) {
        return Datatypes.createTypedLiteral(model, new Long(l), string);
    }

    public static Literal createTypedLiteral(Model model, short s, String string) {
        return Datatypes.createTypedLiteral(model, new Short(s), string);
    }

    public static String CalendarToXSD(Calendar calendar, RDFDatatype rDFDatatype) {
        String string = null;
        if (rDFDatatype.equals(XSDDatatype.XSDdate)) {
            string = XSD_date.format(calendar.getTime());
        } else if (rDFDatatype.equals(XSDDatatype.XSDdateTime)) {
            string = XSD_dateTime.format(calendar.getTime());
        } else if (rDFDatatype.equals(XSDDatatype.XSDgDay)) {
            string = XSD_gDay.format(calendar.getTime());
        } else if (rDFDatatype.equals(XSDDatatype.XSDgMonth)) {
            string = XSD_gMonth.format(calendar.getTime());
        } else if (rDFDatatype.equals(XSDDatatype.XSDgMonthDay)) {
            string = XSD_gMonthDay.format(calendar.getTime());
        } else if (rDFDatatype.equals(XSDDatatype.XSDgYear)) {
            string = XSD_gYear.format(calendar.getTime());
        } else if (rDFDatatype.equals(XSDDatatype.XSDgYearMonth)) {
            string = XSD_gYearMonth.format(calendar.getTime());
        } else if (rDFDatatype.equals(XSDDatatype.XSDtime)) {
            string = XSD_time.format(calendar.getTime());
        } else {
            return calendar.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.insert(stringBuffer.length() - 2, ':');
        return stringBuffer.toString();
    }
}

