/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.clips;

import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.plugin.AbstractCreateProjectPlugin;
import edu.stanford.smi.protege.plugin.CreateProjectWizard;
import edu.stanford.smi.protege.storage.clips.ClipsFilesPlugin;
import edu.stanford.smi.protege.storage.clips.ClipsFilesWizardPage;
import edu.stanford.smi.protege.storage.clips.ClipsKnowledgeBaseFactory;
import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.PropertyList;
import edu.stanford.smi.protege.util.WizardPage;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

public class ClipsFilesCreateProjectPlugin
extends AbstractCreateProjectPlugin
implements ClipsFilesPlugin {
    private String clsesFileName;
    private String instancesFileName;
    private Collection includedProjects;

    public ClipsFilesCreateProjectPlugin() {
        super(ClipsKnowledgeBaseFactory.DESCRIPTION);
    }

    public void setFiles(String string, String string2) {
        this.clsesFileName = string;
        this.instancesFileName = string2;
    }

    public void setIncludedProjects(Collection collection) {
        this.includedProjects = new ArrayList(collection);
    }

    public boolean canCreateProject(KnowledgeBaseFactory knowledgeBaseFactory, boolean bl) {
        return knowledgeBaseFactory.getClass() == ClipsKnowledgeBaseFactory.class;
    }

    protected void initialize(Project project) {
        super.initialize(project);
        if (this.includedProjects != null) {
            for (URI uRI : this.includedProjects) {
                project.includeProject(uRI, false, null);
            }
        }
    }

    protected void initializeSources(PropertyList propertyList) {
        String string = FileUtilities.getName(this.clsesFileName);
        String string2 = FileUtilities.getName(this.instancesFileName);
        ClipsKnowledgeBaseFactory.setSourceFiles(propertyList, string, string2);
    }

    protected URI getBuildProjectURI() {
        String string = this.clsesFileName.substring(0, this.clsesFileName.length() - 5);
        string = string + ".pprj";
        File file = new File(string);
        return file.toURI();
    }

    public WizardPage createCreateProjectWizardPage(CreateProjectWizard createProjectWizard, boolean bl) {
        ClipsFilesWizardPage clipsFilesWizardPage = null;
        if (bl) {
            clipsFilesWizardPage = new ClipsFilesWizardPage(createProjectWizard, this);
        }
        return clipsFilesWizardPage;
    }
}

